<?php 
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.8
 * 
 * Admin Panel Element Options
 * Created by CMSMasters
 * 
 */


function amigos_options_element_tabs() {
	$tabs = array();
	
	$tabs['sidebar'] = esc_attr__('Sidebars', 'amigos');
	
	if (class_exists('Cmsmasters_Content_Composer')) {
		$tabs['icon'] = esc_attr__('Social Icons', 'amigos');
	}
	
	$tabs['lightbox'] = esc_attr__('Lightbox', 'amigos');
	$tabs['sitemap'] = esc_attr__('Sitemap', 'amigos');
	$tabs['error'] = esc_attr__('404', 'amigos');
	$tabs['code'] = esc_attr__('Custom Codes', 'amigos');
	
	if (class_exists('Cmsmasters_Form_Builder')) {
		$tabs['recaptcha'] = esc_attr__('reCAPTCHA', 'amigos');
	}
	
	return apply_filters('cmsmasters_options_element_tabs_filter', $tabs);
}


function amigos_options_element_sections() {
	$tab = amigos_get_the_tab();
	
	switch ($tab) {
	case 'sidebar':
		$sections = array();
		
		$sections['sidebar_section'] = esc_attr__('Custom Sidebars', 'amigos');
		
		break;
	case 'icon':
		$sections = array();
		
		$sections['icon_section'] = esc_attr__('Social Icons', 'amigos');
		
		break;
	case 'lightbox':
		$sections = array();
		
		$sections['lightbox_section'] = esc_attr__('Theme Lightbox Options', 'amigos');
		
		break;
	case 'sitemap':
		$sections = array();
		
		$sections['sitemap_section'] = esc_attr__('Sitemap Page Options', 'amigos');
		
		break;
	case 'error':
		$sections = array();
		
		$sections['error_section'] = esc_attr__('404 Error Page Options', 'amigos');
		
		break;
	case 'code':
		$sections = array();
		
		$sections['code_section'] = esc_attr__('Custom Codes', 'amigos');
		
		break;
	case 'recaptcha':
		$sections = array();
		
		$sections['recaptcha_section'] = esc_attr__('Form Builder Plugin reCAPTCHA Keys', 'amigos');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_element_sections_filter', $sections, $tab);	
} 


function amigos_options_element_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = amigos_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = amigos_settings_element_defaults();
	
	
	switch ($tab) {
	case 'sidebar':
		$options[] = array( 
			'section' => 'sidebar_section', 
			'id' => 'amigos' . '_sidebar', 
			'title' => esc_html__('Custom Sidebars', 'amigos'), 
			'desc' => '', 
			'type' => 'sidebar', 
			'std' => $defaults[$tab]['amigos' . '_sidebar'] 
		);
		
		break;
	case 'icon':
		$options[] = array( 
			'section' => 'icon_section', 
			'id' => 'amigos' . '_social_icons', 
			'title' => esc_html__('Social Icons', 'amigos'), 
			'desc' => '', 
			'type' => 'social', 
			'std' => $defaults[$tab]['amigos' . '_social_icons'] 
		);
		
		break;
	case 'lightbox':
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_skin', 
			'title' => esc_html__('Skin', 'amigos'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_skin'], 
			'choices' => array( 
				esc_html__('Dark', 'amigos') . '|dark', 
				esc_html__('Light', 'amigos') . '|light', 
				esc_html__('Mac', 'amigos') . '|mac', 
				esc_html__('Metro Black', 'amigos') . '|metro-black', 
				esc_html__('Metro White', 'amigos') . '|metro-white', 
				esc_html__('Parade', 'amigos') . '|parade', 
				esc_html__('Smooth', 'amigos') . '|smooth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_path', 
			'title' => esc_html__('Path', 'amigos'), 
			'desc' => esc_html__('Sets path for switching windows', 'amigos'), 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_path'], 
			'choices' => array( 
				esc_html__('Vertical', 'amigos') . '|vertical', 
				esc_html__('Horizontal', 'amigos') . '|horizontal' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_infinite', 
			'title' => esc_html__('Infinite', 'amigos'), 
			'desc' => esc_html__('Sets the ability to infinite the group', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_infinite'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_aspect_ratio', 
			'title' => esc_html__('Keep Aspect Ratio', 'amigos'), 
			'desc' => esc_html__('Sets the resizing method used to keep aspect ratio within the viewport', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_aspect_ratio'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_mobile_optimizer', 
			'title' => esc_html__('Mobile Optimizer', 'amigos'), 
			'desc' => esc_html__('Make lightboxes optimized for giving better experience with mobile devices', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_mobile_optimizer'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_max_scale', 
			'title' => esc_html__('Max Scale', 'amigos'), 
			'desc' => esc_html__('Sets the maximum viewport scale of the content', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_max_scale'], 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_min_scale', 
			'title' => esc_html__('Min Scale', 'amigos'), 
			'desc' => esc_html__('Sets the minimum viewport scale of the content', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_min_scale'], 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_inner_toolbar', 
			'title' => esc_html__('Inner Toolbar', 'amigos'), 
			'desc' => esc_html__('Bring buttons into windows, or let them be over the overlay', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_inner_toolbar'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_smart_recognition', 
			'title' => esc_html__('Smart Recognition', 'amigos'), 
			'desc' => esc_html__('Sets content auto recognize from web pages', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_smart_recognition'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_fullscreen_one_slide', 
			'title' => esc_html__('Fullscreen One Slide', 'amigos'), 
			'desc' => esc_html__('Decide to fullscreen only one slide or hole gallery the fullscreen mode', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_fullscreen_one_slide'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_fullscreen_viewport', 
			'title' => esc_html__('Fullscreen Viewport', 'amigos'), 
			'desc' => esc_html__('Sets the resizing method used to fit content within the fullscreen mode', 'amigos'), 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_fullscreen_viewport'], 
			'choices' => array( 
				esc_html__('Center', 'amigos') . '|center', 
				esc_html__('Fit', 'amigos') . '|fit', 
				esc_html__('Fill', 'amigos') . '|fill', 
				esc_html__('Stretch', 'amigos') . '|stretch' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_toolbar', 
			'title' => esc_html__('Toolbar Controls', 'amigos'), 
			'desc' => esc_html__('Sets buttons be available or not', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_toolbar'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_arrows', 
			'title' => esc_html__('Arrow Controls', 'amigos'), 
			'desc' => esc_html__('Enable the arrow buttons', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_arrows'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_fullscreen', 
			'title' => esc_html__('Fullscreen Controls', 'amigos'), 
			'desc' => esc_html__('Sets the fullscreen button', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_fullscreen'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_thumbnail', 
			'title' => esc_html__('Thumbnails Controls', 'amigos'), 
			'desc' => esc_html__('Sets the thumbnail navigation', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_thumbnail'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_keyboard', 
			'title' => esc_html__('Keyboard Controls', 'amigos'), 
			'desc' => esc_html__('Sets the keyboard navigation', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_keyboard'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_mousewheel', 
			'title' => esc_html__('Mouse Wheel Controls', 'amigos'), 
			'desc' => esc_html__('Sets the mousewheel navigation', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_mousewheel'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_swipe', 
			'title' => esc_html__('Swipe Controls', 'amigos'), 
			'desc' => esc_html__('Sets the swipe navigation', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_swipe'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'amigos' . '_ilightbox_controls_slideshow', 
			'title' => esc_html__('Slideshow Controls', 'amigos'), 
			'desc' => esc_html__('Enable the slideshow feature and button', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_ilightbox_controls_slideshow'] 
		);
		
		break;
	case 'sitemap':
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'amigos' . '_sitemap_nav', 
			'title' => esc_html__('Website Pages', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_sitemap_nav'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'amigos' . '_sitemap_categs', 
			'title' => esc_html__('Blog Archives by Categories', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_sitemap_categs'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'amigos' . '_sitemap_tags', 
			'title' => esc_html__('Blog Archives by Tags', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_sitemap_tags'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'amigos' . '_sitemap_month', 
			'title' => esc_html__('Blog Archives by Month', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_sitemap_month'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'amigos' . '_sitemap_pj_categs', 
			'title' => esc_html__('Portfolio Archives by Categories', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_sitemap_pj_categs'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'amigos' . '_sitemap_pj_tags', 
			'title' => esc_html__('Portfolio Archives by Tags', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_sitemap_pj_tags'] 
		);
		
		break;
	case 'error':
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_color', 
			'title' => esc_html__('Text Color', 'amigos'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['amigos' . '_error_color'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_color', 
			'title' => esc_html__('Background Color', 'amigos'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_color'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_img_enable'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_image', 
			'title' => esc_html__('Background Image', 'amigos'), 
			'desc' => esc_html__('Choose your custom error page background image.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_image'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_rep', 
			'title' => esc_html__('Background Repeat', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_rep'], 
			'choices' => array( 
				esc_html__('No Repeat', 'amigos') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'amigos') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'amigos') . '|repeat-y', 
				esc_html__('Repeat', 'amigos') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_pos', 
			'title' => esc_html__('Background Position', 'amigos'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_pos'], 
			'choices' => array( 
				esc_html__('Top Left', 'amigos') . '|top left', 
				esc_html__('Top Center', 'amigos') . '|top center', 
				esc_html__('Top Right', 'amigos') . '|top right', 
				esc_html__('Center Left', 'amigos') . '|center left', 
				esc_html__('Center Center', 'amigos') . '|center center', 
				esc_html__('Center Right', 'amigos') . '|center right', 
				esc_html__('Bottom Left', 'amigos') . '|bottom left', 
				esc_html__('Bottom Center', 'amigos') . '|bottom center', 
				esc_html__('Bottom Right', 'amigos') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_att', 
			'title' => esc_html__('Background Attachment', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_att'], 
			'choices' => array( 
				esc_html__('Scroll', 'amigos') . '|scroll', 
				esc_html__('Fixed', 'amigos') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_bg_size', 
			'title' => esc_html__('Background Size', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_error_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'amigos') . '|auto', 
				esc_html__('Cover', 'amigos') . '|cover', 
				esc_html__('Contain', 'amigos') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_search', 
			'title' => esc_html__('Search Line', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_error_search'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_sitemap_button', 
			'title' => esc_html__('Sitemap Button', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_error_sitemap_button'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'amigos' . '_error_sitemap_link', 
			'title' => esc_html__('Sitemap Page URL', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_error_sitemap_link'], 
			'class' => '' 
		);
		
		break;
	case 'code':
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'amigos' . '_custom_css', 
			'title' => esc_html__('Custom CSS', 'amigos'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['amigos' . '_custom_css'], 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'amigos' . '_custom_js', 
			'title' => esc_html__('Custom JavaScript', 'amigos'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['amigos' . '_custom_js'], 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'amigos' . '_gmap_api_key', 
			'title' => esc_html__('Google Maps API key', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_gmap_api_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'amigos' . '_twitter_access_token', 
			'title' => esc_html__('Twitter Access Token', 'amigos'), 
			'desc' => sprintf(
				/* translators: Twitter access token. %s: Link to twitter access token generator */
				esc_html__( 'Generate %s and paste Access Token to this field.', 'amigos' ),
				'<a href="' . esc_url( 'https://api.cmsmasters.net/wp-json/cmsmasters-api/v1/twitter-request-token' ) . '" target="_blank">' .
					esc_html__( 'twitter access token', 'amigos' ) .
				'</a>'
			), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_twitter_access_token'], 
			'class' => '' 
		);
		
		break;
	case 'recaptcha':
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'amigos' . '_recaptcha_public_key', 
			'title' => esc_html__('reCAPTCHA Public Key', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_recaptcha_public_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'amigos' . '_recaptcha_private_key', 
			'title' => esc_html__('reCAPTCHA Private Key', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_recaptcha_private_key'], 
			'class' => '' 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_element_fields_filter', $options, $tab);	
}

