<?php 
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version		1.0.2
 * 
 * Admin Panel Fonts Options
 * Created by CMSMasters
 * 
 */


function amigos_options_font_tabs() {
	$tabs = array();
	
	$tabs['content'] = esc_attr__('Content', 'amigos');
	$tabs['link'] = esc_attr__('Links', 'amigos');
	$tabs['nav'] = esc_attr__('Navigation', 'amigos');
	$tabs['heading'] = esc_attr__('Heading', 'amigos');
	$tabs['other'] = esc_attr__('Other', 'amigos');
	$tabs['google'] = esc_attr__('Google Fonts', 'amigos');
	
	return apply_filters('cmsmasters_options_font_tabs_filter', $tabs);
}


function amigos_options_font_sections() {
	$tab = amigos_get_the_tab();
	
	switch ($tab) {
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_html__('Content Font Options', 'amigos');
		
		break;
	case 'link':
		$sections = array();
		
		$sections['link_section'] = esc_html__('Links Font Options', 'amigos');
		
		break;
	case 'nav':
		$sections = array();
		
		$sections['nav_section'] = esc_html__('Navigation Font Options', 'amigos');
		
		break;
	case 'heading':
		$sections = array();
		
		$sections['heading_section'] = esc_html__('Headings Font Options', 'amigos');
		
		break;
	case 'other':
		$sections = array();
		
		$sections['other_section'] = esc_html__('Other Fonts Options', 'amigos');
		
		break;
	case 'google':
		$sections = array();

		$sections['google_section'] = esc_html__('Serving Google Fonts from CDN', 'amigos');

		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_font_sections_filter', $sections, $tab);
} 


function amigos_options_font_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = amigos_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = amigos_settings_font_defaults();
	
	
	switch ($tab) {
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_content_font', 
			'title' => esc_html__('Main Content Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_content_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		break;
	case 'link':
		$options[] = array( 
			'section' => 'link_section', 
			'id' => 'amigos' . '_link_font', 
			'title' => esc_html__('Links Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_link_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'link_section', 
			'id' => 'amigos' . '_link_hover_decoration', 
			'title' => esc_html__('Links Hover Text Decoration', 'amigos'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['amigos' . '_link_hover_decoration'], 
			'choices' => amigos_text_decoration_list() 
		);
		
		break;
	case 'nav':
		$options[] = array( 
			'section' => 'nav_section', 
			'id' => 'amigos' . '_nav_title_font', 
			'title' => esc_html__('Navigation Title Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_nav_title_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'nav_section', 
			'id' => 'amigos' . '_nav_dropdown_font', 
			'title' => esc_html__('Navigation Dropdown Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_nav_dropdown_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		break;
	case 'heading':
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'amigos' . '_h1_font', 
			'title' => esc_html__('H1 Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_h1_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'amigos' . '_h2_font', 
			'title' => esc_html__('H2 Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_h2_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'amigos' . '_h3_font', 
			'title' => esc_html__('H3 Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_h3_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'amigos' . '_h4_font', 
			'title' => esc_html__('H4 Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_h4_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'amigos' . '_h5_font', 
			'title' => esc_html__('H5 Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_h5_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'amigos' . '_h6_font', 
			'title' => esc_html__('H6 Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_h6_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		break;
	case 'other':
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'amigos' . '_button_font', 
			'title' => esc_html__('Button Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_button_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'amigos' . '_small_font', 
			'title' => esc_html__('Small Tag Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_small_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'amigos' . '_input_font', 
			'title' => esc_html__('Text Fields Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_input_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'amigos' . '_quote_font', 
			'title' => esc_html__('Blockquote Font', 'amigos'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['amigos' . '_quote_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		break;
	case 'google':
		$options[] = array(
			'section' => 'google_section',
			'id' => 'amigos' . '_google_web_fonts',
			'title' => esc_html__('Google Fonts', 'amigos'),
			'desc' => '',
			'type' => 'google_web_fonts',
			'std' => $defaults[$tab]['amigos' . '_google_web_fonts']
		);

		$options[] = array(
			'section' => 'google_section',
			'id' => 'amigos' . '_google_web_fonts_subset',
			'title' => esc_html__('Google Fonts Subset', 'amigos'),
			'desc' => '',
			'type' => 'select_multiple',
			'std' => '',
			'choices' => array(
				esc_html__('Latin Extended', 'amigos') . '|' . 'latin-ext',
				esc_html__('Arabic', 'amigos') . '|' . 'arabic',
				esc_html__('Cyrillic', 'amigos') . '|' . 'cyrillic',
				esc_html__('Cyrillic Extended', 'amigos') . '|' . 'cyrillic-ext',
				esc_html__('Greek', 'amigos') . '|' . 'greek',
				esc_html__('Greek Extended', 'amigos') . '|' . 'greek-ext',
				esc_html__('Vietnamese', 'amigos') . '|' . 'vietnamese',
				esc_html__('Japanese', 'amigos') . '|' . 'japanese',
				esc_html__('Korean', 'amigos') . '|' . 'korean',
				esc_html__('Thai', 'amigos') . '|' . 'thai',
				esc_html__('Bengali', 'amigos') . '|' . 'bengali',
				esc_html__('Devanagari', 'amigos') . '|' . 'devanagari',
				esc_html__('Gujarati', 'amigos') . '|' . 'gujarati',
				esc_html__('Gurmukhi', 'amigos') . '|' . 'gurmukhi',
				esc_html__('Hebrew', 'amigos') . '|' . 'hebrew',
				esc_html__('Kannada', 'amigos') . '|' . 'kannada',
				esc_html__('Khmer', 'amigos') . '|' . 'khmer',
				esc_html__('Malayalam', 'amigos') . '|' . 'malayalam',
				esc_html__('Myanmar', 'amigos') . '|' . 'myanmar',
				esc_html__('Oriya', 'amigos') . '|' . 'oriya',
				esc_html__('Sinhala', 'amigos') . '|' . 'sinhala',
				esc_html__('Tamil', 'amigos') . '|' . 'tamil',
				esc_html__('Telugu', 'amigos') . '|' . 'telugu'
			)
		);

		break;
	}
	
	return apply_filters('cmsmasters_options_font_fields_filter', $options, $tab);	
}

