<?php 
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.4
 * 
 * Admin Panel General Options
 * Created by CMSMasters
 * 
 */


function amigos_options_general_tabs() {
	$cmsmasters_option = amigos_get_global_options();
	
	$tabs = array();
	
	$tabs['general'] = esc_attr__('General', 'amigos');
	
	if ($cmsmasters_option['amigos' . '_theme_layout'] === 'boxed') {
		$tabs['bg'] = esc_attr__('Background', 'amigos');
	}
	
	if (CMSMASTERS_THEME_STYLE_COMPATIBILITY) {
		$tabs['theme_style'] = esc_attr__('Theme Style', 'amigos');
	}
	
	$tabs['header'] = esc_attr__('Header', 'amigos');
	$tabs['content'] = esc_attr__('Content', 'amigos');
	$tabs['footer'] = esc_attr__('Footer', 'amigos');
	
	return apply_filters('cmsmasters_options_general_tabs_filter', $tabs);
}


function amigos_options_general_sections() {
	$tab = amigos_get_the_tab();
	
	switch ($tab) {
	case 'general':
		$sections = array();
		
		$sections['general_section'] = esc_attr__('General Options', 'amigos');
		
		break;
	case 'bg':
		$sections = array();
		
		$sections['bg_section'] = esc_attr__('Background Options', 'amigos');
		
		break;
	case 'theme_style':
		$sections = array();
		
		$sections['theme_style_section'] = esc_attr__('Theme Design Style', 'amigos');
		
		break;
	case 'header':
		$sections = array();
		
		$sections['header_section'] = esc_attr__('Header Options', 'amigos');
		
		break;
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_attr__('Content Options', 'amigos');
		
		break;
	case 'footer':
		$sections = array();
		
		$sections['footer_section'] = esc_attr__('Footer Options', 'amigos');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_general_sections_filter', $sections, $tab);
} 


function amigos_options_general_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = amigos_get_the_tab();
	}
	
	$options = array();
	
	
	$defaults = amigos_settings_general_defaults();
	
	
	switch ($tab) {
	case 'general':
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_theme_layout', 
			'title' => esc_html__('Theme Layout', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_theme_layout'], 
			'choices' => array( 
				esc_html__('Liquid', 'amigos') . '|liquid', 
				esc_html__('Boxed', 'amigos') . '|boxed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_type', 
			'title' => esc_html__('Logo Type', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_logo_type'], 
			'choices' => array( 
				esc_html__('Image', 'amigos') . '|image', 
				esc_html__('Text', 'amigos') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_url', 
			'title' => esc_html__('Logo Image', 'amigos'), 
			'desc' => esc_html__('Choose your website logo image.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_logo_url'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_url_retina', 
			'title' => esc_html__('Retina Logo Image', 'amigos'), 
			'desc' => esc_html__('Choose logo image for retina displays. Logo for Retina displays should be twice the size of the default one.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_logo_url_retina'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_title', 
			'title' => esc_html__('Logo Title', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_logo_title'], 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_subtitle', 
			'title' => esc_html__('Logo Subtitle', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_logo_subtitle'], 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_custom_color', 
			'title' => esc_html__('Custom Text Colors', 'amigos'), 
			'desc' => esc_html__('enable', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_logo_custom_color'] 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_title_color', 
			'title' => esc_html__('Logo Title Color', 'amigos'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['amigos' . '_logo_title_color'] 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'amigos' . '_logo_subtitle_color', 
			'title' => esc_html__('Logo Subtitle Color', 'amigos'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['amigos' . '_logo_subtitle_color'] 
		);
		
		break;
	case 'bg':
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_col', 
			'title' => esc_html__('Background Color', 'amigos'), 
			'desc' => '', 
			'type' => 'color', 
			'std' => $defaults[$tab]['amigos' . '_bg_col'] 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_bg_img_enable'] 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_img', 
			'title' => esc_html__('Background Image', 'amigos'), 
			'desc' => esc_html__('Choose your custom website background image url.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_bg_img'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_rep', 
			'title' => esc_html__('Background Repeat', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_bg_rep'], 
			'choices' => array( 
				esc_html__('No Repeat', 'amigos') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'amigos') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'amigos') . '|repeat-y', 
				esc_html__('Repeat', 'amigos') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_pos', 
			'title' => esc_html__('Background Position', 'amigos'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_bg_pos'], 
			'choices' => array( 
				esc_html__('Top Left', 'amigos') . '|top left', 
				esc_html__('Top Center', 'amigos') . '|top center', 
				esc_html__('Top Right', 'amigos') . '|top right', 
				esc_html__('Center Left', 'amigos') . '|center left', 
				esc_html__('Center Center', 'amigos') . '|center center', 
				esc_html__('Center Right', 'amigos') . '|center right', 
				esc_html__('Bottom Left', 'amigos') . '|bottom left', 
				esc_html__('Bottom Center', 'amigos') . '|bottom center', 
				esc_html__('Bottom Right', 'amigos') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_att', 
			'title' => esc_html__('Background Attachment', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_bg_att'], 
			'choices' => array( 
				esc_html__('Scroll', 'amigos') . '|scroll', 
				esc_html__('Fixed', 'amigos') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'amigos' . '_bg_size', 
			'title' => esc_html__('Background Size', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'amigos') . '|auto', 
				esc_html__('Cover', 'amigos') . '|cover', 
				esc_html__('Contain', 'amigos') . '|contain' 
			) 
		);
		
		break;
	case 'theme_style':
		$options[] = array( 
			'section' => 'theme_style_section', 
			'id' => 'amigos' . '_theme_style', 
			'title' => esc_html__('Choose Theme Style', 'amigos'), 
			'desc' => '', 
			'type' => 'select_theme_style', 
			'std' => '', 
			'choices' => amigos_all_theme_styles() 
		);
		
		break;
	case 'header':
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_fixed_header', 
			'title' => esc_html__('Fixed Header', 'amigos'), 
			'desc' => esc_html__('enable', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_fixed_header'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_overlaps', 
			'title' => esc_html__('Header Overlaps Content by Default', 'amigos'), 
			'desc' => esc_html__('enable', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_header_overlaps'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_top_line', 
			'title' => esc_html__('Top Line', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_header_top_line'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_top_height', 
			'title' => esc_html__('Top Height', 'amigos'), 
			'desc' => esc_html__('pixels', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_header_top_height'], 
			'min' => '10' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_top_line_short_info', 
			'title' => esc_html__('Top Short Info', 'amigos'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'amigos') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['amigos' . '_header_top_line_short_info'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_top_line_add_cont', 
			'title' => esc_html__('Top Additional Content', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_header_top_line_add_cont'], 
			'choices' => array( 
				esc_html__('None', 'amigos') . '|none', 
				esc_html__('Top Line Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'amigos') . '|social',
				esc_html__('Top Line Navigation (will be shown if set in Appearance - Menus tab)', 'amigos') . '|nav'
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_styles', 
			'title' => esc_html__('Header Styles', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_header_styles'], 
			'choices' => array( 
				esc_html__('Default Style', 'amigos') . '|default', 
				esc_html__('Compact Style Left Navigation', 'amigos') . '|l_nav', 
				esc_html__('Compact Style Right Navigation', 'amigos') . '|r_nav', 
				esc_html__('Compact Style Center Navigation', 'amigos') . '|c_nav'
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_mid_height', 
			'title' => esc_html__('Header Middle Height', 'amigos'), 
			'desc' => esc_html__('pixels', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_header_mid_height'], 
			'min' => '40' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_bot_height', 
			'title' => esc_html__('Header Bottom Height', 'amigos'), 
			'desc' => esc_html__('pixels', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_header_bot_height'], 
			'min' => '20' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_search', 
			'title' => esc_html__('Header Search', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_header_search'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_add_cont', 
			'title' => esc_html__('Header Additional Content', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_header_add_cont'], 
			'choices' => array( 
				esc_html__('None', 'amigos') . '|none', 
				esc_html__('Header Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'amigos') . '|social', 
				esc_html__('Header Custom HTML', 'amigos') . '|cust_html' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos' . '_header_add_cont_cust_html', 
			'title' => esc_html__('Header Custom HTML', 'amigos'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'amigos') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['amigos' . '_header_add_cont_cust_html'], 
			'class' => '' 
		);
		
		break;
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_layout', 
			'title' => esc_html__('Layout Type by Default', 'amigos'),
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'amigos'),
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['amigos' . '_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_archives_layout', 
			'title' => esc_html__('Archives Layout Type', 'amigos'),
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Archive Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'amigos'),
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['amigos' . '_archives_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_search_layout', 
			'title' => esc_html__('Search Layout Type', 'amigos'),
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Search Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'amigos'),
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['amigos' . '_search_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_other_layout', 
			'title' => esc_html__('Other Layout Type', 'amigos'),
			'desc' => esc_html__('Layout for pages of non-listed types. Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'amigos'),
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['amigos' . '_other_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_alignment', 
			'title' => esc_html__('Heading Alignment by Default', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_heading_alignment'], 
			'choices' => array( 
				esc_html__('Left', 'amigos') . '|left', 
				esc_html__('Right', 'amigos') . '|right', 
				esc_html__('Center', 'amigos') . '|center' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_scheme', 
			'title' => esc_html__('Heading Color Scheme by Default', 'amigos'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['amigos' . '_heading_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_bg_image_enable', 
			'title' => esc_html__('Heading Background Image Visibility by Default', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_heading_bg_image_enable'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_bg_image', 
			'title' => esc_html__('Heading Background Image by Default', 'amigos'), 
			'desc' => esc_html__('Choose your custom heading background image by default.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_heading_bg_image'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_bg_repeat', 
			'title' => esc_html__('Heading Background Repeat by Default', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_heading_bg_repeat'], 
			'choices' => array( 
				esc_html__('No Repeat', 'amigos') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'amigos') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'amigos') . '|repeat-y', 
				esc_html__('Repeat', 'amigos') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_bg_attachment', 
			'title' => esc_html__('Heading Background Attachment by Default', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_heading_bg_attachment'], 
			'choices' => array( 
				esc_html__('Scroll', 'amigos') . '|scroll', 
				esc_html__('Fixed', 'amigos') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_bg_size', 
			'title' => esc_html__('Heading Background Size by Default', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_heading_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'amigos') . '|auto', 
				esc_html__('Cover', 'amigos') . '|cover', 
				esc_html__('Contain', 'amigos') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_bg_color', 
			'title' => esc_html__('Heading Background Color Overlay by Default', 'amigos'), 
			'desc' => '',  
			'type' => 'rgba', 
			'std' => $defaults[$tab]['amigos' . '_heading_bg_color'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_heading_height', 
			'title' => esc_html__('Heading Height by Default', 'amigos'), 
			'desc' => esc_html__('pixels', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_heading_height'], 
			'min' => '0' 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_breadcrumbs', 
			'title' => esc_html__('Breadcrumbs Visibility by Default', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_breadcrumbs'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_bottom_scheme', 
			'title' => esc_html__('Bottom Color Scheme', 'amigos'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['amigos' . '_bottom_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_bottom_sidebar', 
			'title' => esc_html__('Bottom Sidebar Visibility by Default', 'amigos'),
			'desc' => esc_html__('show', 'amigos') . '<br><br>' . esc_html__('Please make sure to add widgets in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'amigos'),
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_bottom_sidebar'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'amigos' . '_bottom_sidebar_layout', 
			'title' => esc_html__('Bottom Sidebar Layout by Default', 'amigos'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_bottom_sidebar_layout'], 
			'choices' => array( 
				'1/1|11', 
				'1/2 + 1/2|1212', 
				'1/3 + 2/3|1323', 
				'2/3 + 1/3|2313', 
				'1/4 + 3/4|1434', 
				'3/4 + 1/4|3414', 
				'1/3 + 1/3 + 1/3|131313', 
				'1/2 + 1/4 + 1/4|121414', 
				'1/4 + 1/2 + 1/4|141214', 
				'1/4 + 1/4 + 1/2|141412', 
				'1/4 + 1/4 + 1/4 + 1/4|14141414' 
			) 
		);
		
		break;
	case 'footer':
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_scheme', 
			'title' => esc_html__('Footer Color Scheme', 'amigos'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['amigos' . '_footer_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_type', 
			'title' => esc_html__('Footer Type', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_footer_type'], 
			'choices' => array( 
				esc_html__('Default', 'amigos') . '|default', 
				esc_html__('Small', 'amigos') . '|small' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_additional_content', 
			'title' => esc_html__('Footer Additional Content', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['amigos' . '_footer_additional_content'], 
			'choices' => array( 
				esc_html__('None', 'amigos') . '|none',
				esc_html__('Footer Navigation (will be shown if set in Appearance - Menus tab)', 'amigos') . '|nav',
				esc_html__('Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'amigos') . '|social', 
				esc_html__('Custom HTML', 'amigos') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_logo', 
			'title' => esc_html__('Footer Logo', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_footer_logo'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_logo_url', 
			'title' => esc_html__('Footer Logo', 'amigos'), 
			'desc' => esc_html__('Choose your website footer logo image.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_footer_logo_url'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_logo_url_retina', 
			'title' => esc_html__('Footer Logo for Retina', 'amigos'), 
			'desc' => esc_html__('Choose your website footer logo image for retina.', 'amigos'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['amigos' . '_footer_logo_url_retina'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_nav', 
			'title' => esc_html__('Footer Navigation', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_footer_nav'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_social', 
			'title' => esc_html__('Footer Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_footer_social'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_html', 
			'title' => esc_html__('Footer Custom HTML', 'amigos'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'amigos') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['amigos' . '_footer_html'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'amigos' . '_footer_copyright', 
			'title' => esc_html__('Copyright Text', 'amigos'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_footer_copyright'], 
			'class' => '' 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_general_fields_filter', $options, $tab);	
}

