<?php 
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version		1.0.0
 * 
 * Admin Panel Post, Project, Profile Settings
 * Created by CMSMasters
 * 
 */


function amigos_options_single_tabs() {
	$tabs = array();
	
	
	$tabs['post'] = esc_attr__('Post', 'amigos');
	
	if (CMSMASTERS_PROJECT_COMPATIBLE && class_exists('Cmsmasters_Projects')) {
		$tabs['project'] = esc_attr__('Project', 'amigos');
	}
	
	if (CMSMASTERS_PROFILE_COMPATIBLE && class_exists('Cmsmasters_Profiles')) {
		$tabs['profile'] = esc_attr__('Profile', 'amigos');
	}
	
	
	return apply_filters('cmsmasters_options_single_tabs_filter', $tabs);
}


function amigos_options_single_sections() {
	$tab = amigos_get_the_tab();
	
	
	switch ($tab) {
	case 'post':
		$sections = array();
		
		$sections['post_section'] = esc_attr__('Blog Post Options', 'amigos');
		
		
		break;
	case 'project':
		$sections = array();
		
		$sections['project_section'] = esc_attr__('Portfolio Project Options', 'amigos');
		
		
		break;
	case 'profile':
		$sections = array();
		
		$sections['profile_section'] = esc_attr__('Person Block Profile Options', 'amigos');
		
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	
	return apply_filters('cmsmasters_options_single_sections_filter', $sections, $tab);
} 


function amigos_options_single_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = amigos_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = amigos_settings_single_defaults();
	
	
	switch ($tab) {
	case 'post':
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_layout', 
			'title' => esc_html__('Layout Type', 'amigos'), 
			'desc' => '', 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'amigos') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_title', 
			'title' => esc_html__('Post Title', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_title'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_date', 
			'title' => esc_html__('Post Date', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_date'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_cat', 
			'title' => esc_html__('Post Categories', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_cat'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_author', 
			'title' => esc_html__('Post Author', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_author'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_comment', 
			'title' => esc_html__('Post Comments', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_comment'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_tag', 
			'title' => esc_html__('Post Tags', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_tag'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_like', 
			'title' => esc_html__('Post Likes', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_like'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_nav_box', 
			'title' => esc_html__('Posts Navigation Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_nav_box'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_nav_order_cat', 
			'title' => esc_html__('Posts Navigation Order by Category', 'amigos'), 
			'desc' => esc_html__('enable', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_nav_order_cat'] 
		);
		
		if (class_exists('Cmsmasters_Content_Composer')) {
			$options[] = array( 
				'section' => 'post_section', 
				'id' => 'amigos' . '_blog_post_share_box', 
				'title' => esc_html__('Sharing Box', 'amigos'), 
				'desc' => esc_html__('show', 'amigos'), 
				'type' => 'checkbox', 
				'std' => $defaults[$tab]['amigos' . '_blog_post_share_box'] 
			);
		}
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_post_author_box', 
			'title' => esc_html__('About Author Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_blog_post_author_box'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_more_posts_box', 
			'title' => esc_html__('More Posts Box', 'amigos'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_blog_more_posts_box'], 
			'choices' => array( 
				esc_html__('Show Related Posts', 'amigos') . '|related', 
				esc_html__('Show Popular Posts', 'amigos') . '|popular', 
				esc_html__('Show Recent Posts', 'amigos') . '|recent', 
				esc_html__('Hide More Posts Box', 'amigos') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_more_posts_count', 
			'title' => esc_html__('More Posts Box Items Number', 'amigos'), 
			'desc' => esc_html__('posts', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_blog_more_posts_count'], 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'amigos' . '_blog_more_posts_pause', 
			'title' => esc_html__('More Posts Slider Pause Time', 'amigos'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_blog_more_posts_pause'], 
			'min' => '0', 
			'max' => '20' 
		);
		
		
		break;
	case 'project':
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_title', 
			'title' => esc_html__('Project Title', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_title'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_details_title', 
			'title' => esc_html__('Project Details Title', 'amigos'), 
			'desc' => esc_html__('Enter a project details block title', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_details_title'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_date', 
			'title' => esc_html__('Project Date', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_date'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_cat', 
			'title' => esc_html__('Project Categories', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_cat'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_author', 
			'title' => esc_html__('Project Author', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_author'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_comment', 
			'title' => esc_html__('Project Comments', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_comment'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_tag', 
			'title' => esc_html__('Project Tags', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_tag'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_like', 
			'title' => esc_html__('Project Likes', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_like'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_link', 
			'title' => esc_html__('Project Link', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_link'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_share_box', 
			'title' => esc_html__('Sharing Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_share_box'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_nav_box', 
			'title' => esc_html__('Services Navigation Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_nav_box'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_nav_order_cat', 
			'title' => esc_html__('Services Navigation Order by Category', 'amigos'), 
			'desc' => esc_html__('enable', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_nav_order_cat'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_author_box', 
			'title' => esc_html__('About Author Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_author_box'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_more_projects_box', 
			'title' => esc_html__('More Services Box', 'amigos'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_more_projects_box'], 
			'choices' => array( 
				esc_html__('Show Related Services', 'amigos') . '|related', 
				esc_html__('Show Popular Services', 'amigos') . '|popular', 
				esc_html__('Show Recent Services', 'amigos') . '|recent', 
				esc_html__('Hide More Services Box', 'amigos') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_more_projects_count', 
			'title' => esc_html__('More Services Box Items Number', 'amigos'), 
			'desc' => esc_html__('services', 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_more_projects_count'], 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_more_projects_pause', 
			'title' => esc_html__('More Services Slider Pause Time', 'amigos'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'amigos'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_more_projects_pause'], 
			'min' => '0', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_project_slug', 
			'title' => esc_html__('Project Slug', 'amigos'), 
			'desc' => esc_html__('Enter a page slug that should be used for your services single item', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_project_slug'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_pj_categs_slug', 
			'title' => esc_html__('Project Categories Slug', 'amigos'), 
			'desc' => esc_html__('Enter page slug that should be used on services categories archive page', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_pj_categs_slug'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'amigos' . '_portfolio_pj_tags_slug', 
			'title' => esc_html__('Project Tags Slug', 'amigos'), 
			'desc' => esc_html__('Enter page slug that should be used on services tags archive page', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_portfolio_pj_tags_slug'], 
			'class' => '' 
		);
		
		
		break;
	case 'profile':
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_title', 
			'title' => esc_html__('Profile Title', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_title'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_details_title', 
			'title' => esc_html__('Profile Details Title', 'amigos'), 
			'desc' => esc_html__('Enter a profile details block title', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_details_title'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_cat', 
			'title' => esc_html__('Profile Categories', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_cat'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_comment', 
			'title' => esc_html__('Profile Comments', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_comment'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_like', 
			'title' => esc_html__('Profile Likes', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_like'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_nav_box', 
			'title' => esc_html__('Profiles Navigation Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_nav_box'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_nav_order_cat', 
			'title' => esc_html__('Profiles Navigation Order by Category', 'amigos'), 
			'desc' => esc_html__('enable', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_nav_order_cat'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_share_box', 
			'title' => esc_html__('Sharing Box', 'amigos'), 
			'desc' => esc_html__('show', 'amigos'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_share_box'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_post_slug', 
			'title' => esc_html__('Profile Slug', 'amigos'), 
			'desc' => esc_html__('Enter a page slug that should be used for your profiles single item', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_profile_post_slug'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'amigos' . '_profile_pl_categs_slug', 
			'title' => esc_html__('Profile Categories Slug', 'amigos'), 
			'desc' => esc_html__('Enter page slug that should be used on profiles categories archive page', 'amigos'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['amigos' . '_profile_pl_categs_slug'], 
			'class' => '' 
		);
		
		
		break;
	}
	
	
	return apply_filters('cmsmasters_options_single_fields_filter', $options, $tab);
}

