<?php 
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version		1.0.0
 * 
 * Theme Admin Settings
 * Created by CMSMasters
 * 
 */


/* General Settings */
function amigos_theme_options_general_fields($options, $tab) {
	$new_options = array();
	
	if ($tab == 'general') {
		foreach ($options as $option) {
			if ($option['id'] == 'amigos_logo_url_retina') {
				$new_options[] = $option;
				
				$new_options[] = array( 
					'section' => 'general_section', 
					'id' => 'amigos' . '_logo_url_overlaps', 
					'title' => esc_html__('Logo Image For Overlaps', 'amigos'), 
					'desc' => esc_html__('Choose your website logo image for overlaps in header default.', 'amigos'), 
					'type' => 'upload', 
					'std' => '|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_overlaps.png', 
					'frame' => 'select', 
					'multiple' => false 
				);
				
				$new_options[] = array( 
					'section' => 'general_section', 
					'id' => 'amigos' . '_logo_url_retina_overlaps', 
					'title' => esc_html__('Retina Logo Image For Overlaps', 'amigos'), 
					'desc' => esc_html__('Choose logo image for retina displays and overlaps in header default. Logo for Retina displays should be twice the size of the default one.', 'amigos'), 
					'type' => 'upload', 
					'std' => '|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_overlaps_retina.png', 
					'frame' => 'select', 
					'multiple' => false 
				);
			} else {
				$new_options[] = $option;
			}
		}
		
		$options = $new_options;
	} elseif ($tab == 'header') {
		$new_options[] = array( 
			'section' => 'header_section', 
			'id' => 'amigos_header_styles', 
			'title' => esc_html__('Header Styles', 'amigos'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'default', 
			'choices' => array( 
				esc_html__('Default Style', 'amigos') . '|default', 
				esc_html__('Side Style', 'amigos') . '|side' 
			) 
		);
		
		
		foreach ($options as $option) {
			if ($option['id'] == 'amigos_header_styles') {
				// remove this option
			} else {
				$new_options[] = $option;
			}
		}
		
		$options = $new_options;
	}
	
	
	return $options;
}

add_filter('cmsmasters_options_general_fields_filter', 'amigos_theme_options_general_fields', 10, 2);



/* Color Settings */
function amigos_theme_options_color_fields($options, $tab) {
	$new_options = array();
	
	
	if ($tab == 'header') {
		foreach ($options as $option) {
			if (
				$option['id'] == 'amigos' . '_' . $tab . '_bot_color' || 
				$option['id'] == 'amigos' . '_' . $tab . '_bot_link' || 
				$option['id'] == 'amigos' . '_' . $tab . '_bot_hover' || 
				$option['id'] == 'amigos' . '_' . $tab . '_bot_bg' || 
				$option['id'] == 'amigos' . '_' . $tab . '_bot_bg_scroll' || 
				$option['id'] == 'amigos' . '_' . $tab . '_bot_border' 
			) {
				// remove this options
			} elseif ($option['id'] == 'amigos' . '_' . $tab . '_mid_color') {
				$option['title'] = esc_html__('Header Text Font Color', 'amigos');
				
				$new_options[] = $option;
			} elseif ($option['id'] == 'amigos' . '_' . $tab . '_mid_link') {
				$option['title'] = esc_html__('Header Links Font Color', 'amigos');
				
				$new_options[] = $option;
			} elseif ($option['id'] == 'amigos' . '_' . $tab . '_mid_hover') {
				$option['title'] = esc_html__('Header Links Font Color on Hover', 'amigos');
				
				$new_options[] = $option;
			} elseif ($option['id'] == 'amigos' . '_' . $tab . '_mid_bg') {
				$option['title'] = esc_html__('Header Background Color', 'amigos');
				
				$new_options[] = $option;
			} elseif ($option['id'] == 'amigos' . '_' . $tab . '_mid_bg_scroll') {
			} elseif ($option['id'] == 'amigos' . '_' . $tab . '_mid_border') {
				$option['title'] = esc_html__('Header Border Color', 'amigos');
				
				$new_options[] = $option;
			} else {
				$new_options[] = $option;
			}
		}
		
		$options = $new_options;
	} elseif ($tab == 'navigation') {
		foreach ($options as $option) {
			if (
				$option['id'] == 'amigos' . '_' . $tab . '_title_link_subtitle' || 
				$option['id'] == 'amigos' . '_' . $tab . '_dropdown_text' || 
				$option['id'] == 'amigos' . '_' . $tab . '_dropdown_link_subtitle' 
			) {
				// remove this options
			} else {
				$new_options[] = $option;
			}
		}
		
		$options = $new_options;
	}
	
	
	return $options;
}

add_filter('cmsmasters_options_color_fields_filter', 'amigos_theme_options_color_fields', 10, 2);



/* Single Settings */
function amigos_theme_options_single_fields($options, $tab) {
	
	$options_new = array();

	if ($tab == 'post') {
		foreach ($options as $option) {
			if ($option['id'] == 'amigos' . '_blog_post_nav_box') {
				$options_new[] = array( 
					'section' => 'post_section', 
					'id' => 'amigos' . '_blog_post_view', 
					'title' => esc_html__('Post Views', 'amigos'), 
					'desc' => esc_html__('show', 'amigos'), 
					'type' => 'checkbox', 
					'std' => 1 
				);
				
				
				$options_new[] = $option;
			} else {
				$options_new[] = $option;
			}
		}
	} else if ($tab == 'project') {
		foreach ($options as $option) {
			if ($option['id'] == 'amigos' . '_portfolio_project_share_box') {
				$options_new[] = array( 
					'section' => 'project_section', 
					'id' => 'amigos' . '_portfolio_project_view', 
					'title' => esc_html__('Service Views', 'amigos'), 
					'desc' => esc_html__('show', 'amigos'), 
					'type' => 'checkbox', 
					'std' => 1 
				);
				
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_like') {
				$option['title'] = esc_html__('Service Likes', 'amigos');
				
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_link') {
				$option['title'] = esc_html__('Service Link', 'amigos');
				
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_nav_order_cat') {
				$option['title'] = esc_html__('Services Navigation Order by Category', 'amigos');
				
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_details_title') {
				$option['title'] = esc_html__('Service Details Title', 'amigos');
				$option['desc'] = esc_html__('Enter a service details block title', 'amigos');
				
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_date') {
				$option['title'] = esc_html__('Service Date', 'amigos');
				
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_title') {
				$option['title'] = esc_html__('Service Title', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_cat') {
				$option['title'] = esc_html__('Service Categories', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_author') {
				$option['title'] = esc_html__('Service Author', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_comment') {
				$option['title'] = esc_html__('Service Comments', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_tag') {
				$option['title'] = esc_html__('Service Tags', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_nav_box') {	
				$option['title'] = esc_html__('Services Navigation Box', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_more_projects_box') {
				$option['title'] = esc_html__('More Services Box', 'amigos');
				$option['choices'] = array( 
					esc_html__('Show Related Services', 'amigos') . '|related', 
					esc_html__('Show Popular Services', 'amigos') . '|popular', 
					esc_html__('Show Recent Services', 'amigos') . '|recent', 
					esc_html__('Hide More Services Box', 'amigos') . '|hide' 
				);
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_more_projects_count') {
				$option['title'] = esc_html__('More Services Box Items Number', 'amigos');
				$option['desc'] = esc_html__('services', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_more_projects_pause') {
				$option['title'] = esc_html__('More Services Slider Pause Time', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_project_slug') {
				$option['title'] = esc_html__('Service Slug', 'amigos');
				$option['desc'] = esc_html__('Enter a page slug that should be used for your services single item', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_pj_categs_slug') {
				$option['title'] = esc_html__('Service Categories Slug', 'amigos');
				$option['desc'] = esc_html__('Enter page slug that should be used on services categories archive page', 'amigos');
				
				$options_new[] = $option;
			} elseif ($option['id'] == 'amigos' . '_portfolio_pj_tags_slug') {
				$option['title'] = esc_html__('Service Categories Slug', 'amigos');
				$option['desc'] = esc_html__('Enter page slug that should be used on services tags archive page', 'amigos');
				
				$options_new[] = $option;
			} else {
				$options_new[] = $option;
			}
		}
	} else {
		$options_new = $options;
	}
	
	
	return $options_new;
}

add_filter('cmsmasters_options_single_fields_filter', 'amigos_theme_options_single_fields', 10, 2);



/* Single Tabs */
function amigos_theme_options_single_tabs($tabs) {
	$tabs['project'] = esc_attr__('Service', 'amigos');
	
	return $tabs;
}

add_filter('cmsmasters_options_single_tabs_filter', 'amigos_theme_options_single_tabs', 10, 2);



/* Single Sections */
function amigos_theme_options_single_sections($sections, $tab) {
	if ($tab == 'project') {
		$sections['project_section'] = esc_attr__('Service Options', 'amigos');
	}
	
	return $sections;
}

add_filter('cmsmasters_options_single_sections_filter', 'amigos_theme_options_single_sections', 10, 2);
