<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.0
 * 
 * Theme Content Composer Functions
 * Created by CMSMasters
 * 
 */


/* Register JS Scripts */
function amigos_theme_register_c_c_scripts() {
	global $pagenow;
	
	
	if ( 
		$pagenow == 'post-new.php' || 
		($pagenow == 'post.php' && isset($_GET['post']) && get_post_type($_GET['post']) != 'attachment') 
	) {
		wp_enqueue_script('amigos-composer-shortcodes-extend', get_template_directory_uri() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/js/cmsmasters-c-c-theme-extend.js', array('cmsmasters_composer_shortcodes_js'), '1.0.0', true);
		
		wp_localize_script('amigos-composer-shortcodes-extend', 'cmsmasters_theme_shortcodes', array( 
			/* Blog */
			'choice_view' => 					esc_attr__('Views', 'amigos'), 
			/* Gallery */
			'gallery_field_img_info_title' => 	esc_attr__('Image Info', 'amigos'), 
			
			'portfolio_title' => 									esc_attr__('Services', 'amigos'), 
			'portfolio_field_orderby_descr' => 						esc_attr__('Choose your services order by parameter', 'amigos'), 			
			'portfolio_field_pj_number_title' =>					esc_attr__('Services Number', 'amigos'),
			'portfolio_field_pj_number_descr' =>					esc_attr__('Enter the number of services for showing per page', 'amigos'),
			'portfolio_field_pj_number_descr_note' =>				esc_attr__('number, if empty - show all services', 'amigos'), 
			'portfolio_field_categories_descr' =>					esc_attr__('Show services associated with certain categories.', 'amigos'),
			'portfolio_field_categories_descr_note' =>				esc_attr__("If you don't choose any service categories, all your services will be shown", 'amigos'),			
			'portfolio_field_layout_descr' =>						esc_attr__('Choose layout type for your services', 'amigos'),
			'portfolio_field_layout_choice_grid' =>					esc_attr__('Services Grid', 'amigos'),
			'portfolio_field_layout_mode_descr' =>					esc_attr__('Choose grid layout mode for your services', 'amigos'),			
			'portfolio_field_col_count_descr' =>					esc_attr__('Choose number of services per row', 'amigos'),
			'portfolio_field_metadata_descr' =>						esc_attr__('Choose services metadata that you want to show', 'amigos'),
			'portfolio_field_gap_descr' =>							esc_attr__('Choose the gap between services', 'amigos'),
			'portfolio_field_filter_descr' =>						esc_attr__('If checked, enable services category filter', 'amigos'),
			'portfolio_field_sorting_descr' =>						esc_attr__('If checked, enable services date & name sorting', 'amigos'), 
			
			'posts_slider_field_poststype_choice_project' =>		esc_attr__('Services', 'amigos'),
			'posts_slider_field_pjcateg_title' =>					esc_attr__('Services Categories', 'amigos'),
			'posts_slider_field_pjcateg_descr' =>					esc_attr__('Show services associated with certain categories.', 'amigos'),
			'posts_slider_field_pjcateg_descr_note' =>				esc_attr__("If you don't choose any services categories, all your services will be shown", 'amigos'),			
			'posts_slider_field_col_count_descr' =>					esc_attr__('Choose number of services per row', 'amigos'),			
			'posts_slider_field_pjmeta_title' =>					esc_attr__('Services Metadata', 'amigos'),
			'posts_slider_field_pjmeta_descr' =>					esc_attr__('Choose services metadata you want to be shown', 'amigos')
		));
	}
}

add_action('admin_enqueue_scripts', 'amigos_theme_register_c_c_scripts');


// Gallery Shortcode Attributes Filter
add_filter('cmsmasters_gallery_atts_filter', 'cmsmasters_gallery_atts');

function cmsmasters_gallery_atts() {
	return array( 
		'shortcode_id' => 			'', 
		'layout' => 				'', 
		'gallery_type' => 			'grid', 
		'gallery_count' => 			'', 
		'image_info' => 			'false', 
		'gallery_more_text' => 		'', 
		'gallery_padding' => 		'10', 
		'image_size_slider' => 		'', 
		'image_size_gallery' => 	'', 
		'hover_pause' => 			'5', 
		'hover_active' => 			'1', 
		'hover_pause_on_hover' => 	'true', 
		'slider_effect' => 			'', 
		'slider_autoplay' => 		'', 
		'slider_slideshow_speed' => '7', 
		'slider_animation_speed' => '600', 
		'slider_pause_on_hover' => 	'', 
		'slider_rewind' => 			'', 
		'slider_rewind_speed' => 	'1000', 
		'slider_nav_control' => 	'', 
		'slider_nav_arrow' => 		'', 
		'gallery_columns' => 		'', 
		'gallery_links' => 			'', 
		'animation' => 				'', 
		'animation_delay' => 		'', 
		'classes' => 				'' 
	);
}

