<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.0
 * 
 * Theme Primary Color Schemes Rules
 * Created by CMSMasters
 * 
 */


function amigos_theme_colors_primary() {
	$cmsmasters_option = amigos_get_global_options();
	
	
	$cmsmasters_color_schemes = cmsmasters_color_schemes_list();
	
	
	$custom_css = "/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.0
 * 
 * Theme Primary Color Schemes Rules
 * Created by CMSMasters
 * 
 */

";
	
	
	foreach ($cmsmasters_color_schemes as $scheme => $title) {
		$rule = (($scheme != 'default') ? "html .cmsmasters_color_scheme_{$scheme} " : '');
		
		
		$custom_css .= "
/***************** Start {$title} Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	" . (($scheme == 'default') ? "body," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme}," : '') . "
	{$rule}input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	{$rule}textarea,
	{$rule}select,
	{$rule}option,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info a,
	{$rule}.cmsmasters_post_masonry .cmsmasters_post_cont_info,
	{$rule}.cmsmasters_post_masonry .cmsmasters_post_cont_info a,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_cont_info,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_cont_info a,
	{$rule}.cmsmasters_open_post .cmsmasters_post_cont_info,
	{$rule}.cmsmasters_open_post .cmsmasters_post_cont_info a,
	{$rule}.cmsmasters_comment_item .cmsmasters_comment_item_avatar_wrap .comment-edit-link,
	{$rule}.cmsmasters_archive_type .cmsmasters_archive_item_info a,
	{$rule}.widget_tag_cloud a,
	{$rule}.widget_categories a,
	{$rule}.widget_archive a,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_subtitle,	
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap *,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_author a,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_category a,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info > span,
	{$rule}.cmsmasters_profile_horizontal .cmsmasters_profile_header .cmsmasters_profile_subtitle {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}

	#fbuilder fieldset {
		background-color: transparent;
	}
	
	{$rule}input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}textarea::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}input:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}textarea:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.cmsmasters_tabs.tabs_mode_tour .cmsmasters_tabs_list_item.current_tab a:after,
	{$rule}.cmsmasters_tabs.tabs_mode_tour .cmsmasters_tabs_list_item a:hover:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.cmsmasters_tabs.tabs_mode_tab .cmsmasters_tabs_list_item.current_tab a > span {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
	}
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}a,
	{$rule}.color_2,
	{$rule}.cmsmasters_icon_wrap a .cmsmasters_simple_icon,
	{$rule}.cmsmasters_wrap_more_items.cmsmasters_loading:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_heading_left .icon_box_heading:before,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon:before,
	{$rule}.bypostauthor > .comment-body .alignleft:before,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > a:hover,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > a:hover,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > a:hover,
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_edit a, 
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_meta a,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap a:hover,
	{$rule}.cmsmasters_open_profile .profile_details_item .cmsmasters_profile_category a,
	{$rule}.cmsmasters_open_project .project_details_item .cmsmasters_project_category a,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quote_subtitle_wrap a:hover,
	{$rule}.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content a:hover,
	{$rule}.about_author .about_author_cont > a:hover,
	{$rule}.search_bar_wrap .search_button button,
	{$rule}.cmsmasters_post_default a .cmsmasters_post_date,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_content > *,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_site a,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_author a:hover,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_category a:hover,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_header .cmsmasters_slider_post_title a:hover,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_read_more:hover,
	{$rule}.cmsmasters_toggles .cmsmasters_toggle_title a:hover,
	{$rule}.cmsmasters_toggles .cmsmasters_toggle_wrap.current_toggle .cmsmasters_toggle_title a,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info > span a:hover,
	{$rule}.cmsmasters_post_default .cmsmasters_post_header .cmsmasters_post_title a:hover,	
	{$rule}#page #fbuilder .fields input.codepeoplecalculatedfield,
	{$rule}.cmsmasters_post_default .cmsmasters_post_read_more,
	{$rule}#fbuilder .fields.cff-calculated-field input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]) {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	" . (($scheme == 'default') ? "mark," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme} mark," : '') . "
	{$rule}.cmsmasters_button,
	{$rule}.button,
	{$rule}input[type=submit],
	{$rule}input[type=button],
	{$rule}button,
	{$rule}.img_placeholder_small,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left:before,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_bg .cmsmasters_icon_list_item .cmsmasters_icon_list_icon,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_item:hover .cmsmasters_icon_list_icon,
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=checkbox] + span.wpcf7-list-item-label:after,
	{$rule}.cmsmasters-form-builder .check_parent input[type=checkbox] + label:after,
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=radio] + span.wpcf7-list-item-label:after,
	{$rule}.cmsmasters-form-builder .check_parent input[type=radio] + label:after,
	{$rule}.cmsmasters_clients_slider_wrap.enable_arrow_control .owl-buttons > div:hover > span:before,
	{$rule}.cmsmasters_clients_slider_wrap.enable_arrow_control .owl-buttons > div:hover > span:after,
	{$rule}.cmsmasters_pricing_table .pricing_best_title,
	{$rule}.cmsmasters_twitter_wrap .owl-buttons > div > span:before,
	{$rule}.cmsmasters_twitter_wrap .owl-buttons > div > span:after,
	{$rule}.cmsmasters_profile_horizontal .cmsmasters_profile_img_wrap.not_image .cmsmasters_img_wrap,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_img_wrap.not_image .cmsmasters_img_wrap,
	{$rule}.cmsmasters_project_grid .cmsmasters_project_image_wrap .img_placeholder,
	{$rule}.cmsmasters_project_puzzle .project_outer .img_placeholder,
	{$rule}.cmsmasters_single_slider .cmsmasters_single_slider_item .img_placeholder,
	{$rule}.cmsmasters_posts_slider .preloader .img_placeholder,
	{$rule}.widget_custom_popular_projects_entries .preloader .img_placeholder,
	{$rule}.widget_custom_latest_projects_entries .preloader .img_placeholder,
	{$rule}.cmsmasters_quotes_slider .owl-buttons > div:hover > span:before,
	{$rule}#fbuilder input[type=checkbox] + .field_before:after,
	{$rule}#fbuilder input[type=radio] + .field_before:after,
	{$rule}.cmsmasters_quotes_slider .owl-buttons > div:hover > span:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}

	{$rule}#page #fbuilder .fields input.codepeoplecalculatedfield {
		background-color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_link']) . ", .1);
	}
	
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_border .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:after {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	{$rule}a:hover,
	{$rule}h1 a:hover,
	{$rule}h2 a:hover,
	{$rule}h3 a:hover,
	{$rule}h4 a:hover,
	{$rule}h5 a:hover,
	{$rule}h6 a:hover,
	{$rule}.img_placeholder_small,
	{$rule}.cmsmasters_likes a:hover,
	{$rule}.cmsmasters_likes a.active,
	{$rule}.cmsmasters_comments a:hover,
	{$rule}.cmsmasters_dropcap.type1,
	{$rule}.cmsmasters_icon_wrap a:hover .cmsmasters_simple_icon,
	{$rule}a.cmsmasters_cat_color:hover,
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_edit a:hover,
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_meta a:hover,
	{$rule}.subpage_nav > span,
	{$rule}.cmsmasters_footer_default .footer_nav > li.current_page_item a,
	{$rule}.cmsmasters_footer_default .footer_nav > li.current-menu-item a,
	{$rule}.cmsmasters_footer_small .footer_nav > li.current_page_item a,
	{$rule}.cmsmasters_footer_small .footer_nav > li.current-menu-item a,
	{$rule}.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner:before,
	{$rule}.cmsmasters_pricing_table .pricing_line,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_list:after,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quote_subtitle_wrap,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quote_subtitle_wrap *,
	{$rule}.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content a,
	{$rule}.cmsmasters_tabs .cmsmasters_tabs_list_item a,
	{$rule}.cmsmasters_wrap_pagination ul li .page-numbers.current,
	{$rule}.cmsmasters_post_default .cmsmasters_post_date,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info a:hover,
	{$rule}.cmsmasters_post_default:before,
	{$rule}.cmsmasters_post_default a:hover .cmsmasters_post_date,
	{$rule}.cmsmasters_post_masonry .cmsmasters_post_cont_info a:hover,
	{$rule}.cmsmasters_post_masonry .cmsmasters_post_read_more:hover,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_cont_info a:hover,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_read_more:hover,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_info .cmsmasters_day,
	{$rule}.cmsmasters_open_post .cmsmasters_post_cont_info a:hover,
	{$rule}.cmsmasters_comment_item .cmsmasters_comment_item_avatar_wrap .comment-edit-link:hover,
	{$rule}.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap .cmsmasters_comment_item_date,
	{$rule}.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap .comment-reply-link:hover,
	{$rule}.about_author .about_author_cont > a,
	{$rule}.post_nav > span a:hover,
	{$rule}.post_nav > span a:hover + span + .sub,
	{$rule}.cmsmasters_profile_horizontal .cmsmasters_profile_img_wrap.not_image .cmsmasters_img_wrap a:before,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_img_wrap.not_image .cmsmasters_img_wrap:before,
	{$rule}.cmsmasters_profile_vertical .cmsmasters_profile_header:before,
	{$rule}.cmsmasters_open_profile .profile_social_icons_list a:hover,
	{$rule}.cmsmasters_open_profile .profile_details_item a.active,
	{$rule}.cmsmasters_open_profile .profile_details_item a:hover,
	{$rule}.cmsmasters_open_profile .profile_features_item a:hover,
	{$rule}.cmsmasters_open_profile .profile_details_item .cmsmasters_profile_category,
	{$rule}.cmsmasters_project_grid .cmsmasters_project_image_wrap .img_placeholder,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li:hover a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li.current a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but:hover,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but.current,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but.reversed,
	{$rule}.cmsmasters_project_puzzle .project_outer .img_placeholder,
	{$rule}.cmsmasters_open_project .project_details_item a:hover,
	{$rule}.cmsmasters_open_project .project_features_item a:hover,
	{$rule}.cmsmasters_open_project .project_details_item a.active,
	{$rule}.cmsmasters_open_project .project_details_item .cmsmasters_project_category,
	{$rule}.cmsmasters_single_slider .cmsmasters_single_slider_item .img_placeholder,
	{$rule}.cmsmasters_posts_slider .preloader .img_placeholder,
	{$rule}.cmsmasters_archive_type .cmsmasters_archive_item_info a:hover,
	{$rule}.widget_custom_twitter_entries .tweet_time,
	{$rule}.widget_tag_cloud a:hover,
	{$rule}.search_bar_wrap .search_button button:hover,
	{$rule}.widget_categories a:before,
	{$rule}.widget_archive a:before,
	{$rule}.widget_categories a:hover,
	{$rule}.widget_archive a:hover,
	{$rule}.widget_custom_contact_info_entries > span:before,
	{$rule}.widget_custom_contact_info_entries .adress_wrap:before,
	{$rule}.widget_nav_menu ul li.current_page_item > a,
	{$rule}.widget_pages ul li.current_page_item > a,
	{$rule}.widget_recent_entries .post-date,
	{$rule}.widget_recent_comments ul li,
	{$rule}.widget_custom_popular_projects_entries .preloader .img_placeholder,
	{$rule}.cmsmasters_open_profile .profile_details_item .cmsmasters_profile_category a:hover,
	{$rule}.cmsmasters_open_project .project_details_item .cmsmasters_project_category a:hover,
	{$rule}.widget_custom_latest_projects_entries .preloader .img_placeholder,
	{$rule}.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab .published,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_site a:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_hover']) . "
	}
	
	" . (($scheme == 'default') ? "#slide_top:hover," : '') . "
	{$rule}.cmsmasters_button:hover,
	{$rule}.button:hover,
	{$rule}input[type=submit]:hover,
	{$rule}input[type=button]:hover,
	{$rule}button:hover,
	{$rule}.cmsmasters_dropcap.type2,
	{$rule}.cmsmasters_clients_slider_wrap.enable_arrow_control .owl-buttons > div > span:before,
	{$rule}.cmsmasters_clients_slider_wrap.enable_arrow_control .owl-buttons > div > span:after,
	{$rule}.owl-pagination .owl-page:hover,
	{$rule}.owl-pagination .owl-page.active,
	{$rule}.cmsmasters_twitter_wrap .owl-buttons > div:hover > span:before,
	{$rule}.cmsmasters_twitter_wrap .owl-buttons > div:hover > span:after,
	{$rule}.post_nav > span a:hover + .cmsmasters_nav_arrow:before,
	{$rule}.post_nav > span a:hover + .cmsmasters_nav_arrow:after,
	{$rule}.widget_nav_menu ul li a:hover:before,
	{$rule}.widget_nav_menu ul li.current_page_item > a:before,
	{$rule}.widget_pages ul li a:hover:before,
	{$rule}.widget_pages ul li.current_page_item > a:before,
	{$rule}.cmsmasters_quotes_slider .owl-buttons > div > span:before,
	{$rule}.cmsmasters_quotes_slider .owl-buttons > div > span:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]):focus,
	{$rule}.cmsmasters_footer_default .footer_nav > li.current_page_item a,
	{$rule}.cmsmasters_footer_default .footer_nav > li.current-menu-item a,
	{$rule}.cmsmasters_footer_small .footer_nav > li.current_page_item a,
	{$rule}.cmsmasters_footer_small .footer_nav > li.current-menu-item a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li.current a,
	{$rule}#fbuilder .fields.cff-calculated-field input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]) {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_hover']) . "
	}
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	{$rule}h1,
	{$rule}h2,
	{$rule}h3,
	{$rule}h4,
	{$rule}h5,
	{$rule}h6,
	{$rule}h1 a,
	{$rule}h2 a,
	{$rule}h3 a,
	{$rule}h4 a,
	{$rule}h5 a,
	{$rule}h6 a,
	{$rule}.cmsmasters_likes a,
	{$rule}.cmsmasters_comments a,
	{$rule}.cmsmasters_views,
	{$rule}fieldset legend,
	{$rule}blockquote footer,
	{$rule}table caption,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > a,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > a,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > ul li a:before,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > a,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > ul li a:before,
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap_archive > li a:before,
	{$rule}.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap,
	{$rule}.cmsmasters_pricing_table .cmsmasters_price_wrap,
	{$rule}.cmsmasters_notice .notice_close,
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_content,
	{$rule}.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content,
	{$rule}.cmsmasters_twitter_wrap .twr_icon,
	{$rule}.cmsmasters_toggles .cmsmasters_toggle_title a,
	{$rule}.cmsmasters_tabs .cmsmasters_tabs_list_item a:hover,
	{$rule}.cmsmasters_tabs .cmsmasters_tabs_list_item.current_tab a,
	{$rule}.cmsmasters_post_default .cmsmasters_post_read_more:hover,
	{$rule}.cmsmasters_post_masonry .cmsmasters_post_read_more,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_read_more,
	{$rule}.cmsmasters_post_timeline .cmsmasters_timeline_margin:hover + .cmsmasters_post_info .cmsmasters_day,
	{$rule}.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap .comment-reply-link,
	{$rule}.post_nav > span a,
	{$rule}.cmsmasters_open_post .cmsmasters_post_date,
	{$rule}.cmsmasters_open_post .cmsmasters_post_tags,
	{$rule}.cmsmasters_archive_type .cmsmasters_archive_item_type,
	{$rule}.cmsmasters_open_profile .profile_details_item,
	{$rule}.cmsmasters_open_profile .profile_details_item a,
	{$rule}.cmsmasters_open_profile .profile_features_item,
	{$rule}.cmsmasters_open_profile .profile_features_item a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but,
	{$rule}.cmsmasters_open_project .project_details_item,
	{$rule}.cmsmasters_open_project .project_details_item a,
	{$rule}.cmsmasters_open_project .project_features_item,
	{$rule}.cmsmasters_open_project .project_features_item a,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_read_more {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_heading']) . "
	}
	
	" . (($scheme == 'default') ? "#slide_top," : '') . "
	{$rule}table thead th,
	{$rule}.cmsmasters_icon_list_items .cmsmasters_icon_list_item .cmsmasters_icon_list_icon,
	{$rule}form .formError .formErrorContent,
	{$rule}.cmsmasters_notice .notice_close:hover,
	{$rule}.post_nav > span .cmsmasters_nav_arrow:before,
	{$rule}.post_nav > span .cmsmasters_nav_arrow:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_heading']) . "
	}
	
	{$rule}.cmsmasters_post_default .cmsmasters_owl_slider .owl-buttons > div,
	{$rule}.cmsmasters_post_masonry .cmsmasters_owl_slider .owl-buttons > div,
	{$rule}.cmsmasters_post_timeline .cmsmasters_owl_slider .owl-buttons > div,
	{$rule}.cmsmasters_open_post .cmsmasters_owl_slider .owl-buttons > div,
	{$rule}.cmsmasters_open_project .cmsmasters_owl_slider .owl-buttons > div {
		background-color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_heading']) . ", .3);
	}
	
	{$rule}.cmsmasters_post_default .cmsmasters_owl_slider .owl-buttons > div:hover,
	{$rule}.cmsmasters_post_masonry .cmsmasters_owl_slider .owl-buttons > div:hover,
	{$rule}.cmsmasters_post_timeline .cmsmasters_owl_slider .owl-buttons > div:hover,
	{$rule}.cmsmasters_open_post .cmsmasters_owl_slider .owl-buttons > div:hover,
	{$rule}.cmsmasters_project_grid .project_outer.enable_rollover:hover .cmsmasters_img_rollover a,
	{$rule}.cmsmasters_project_puzzle .project_outer.enable_rollover .project_inner,
	{$rule}.cmsmasters_open_project .cmsmasters_owl_slider .owl-buttons > div:hover {
		background-color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_heading']) . ", .5);
	}
	
	{$rule}.cmsmasters_header_search_form {
		background-color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_heading']) . ", .85);
	}
	
	{$rule}table thead th,
	{$rule}.cmsmasters_notice .notice_close:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	" . (($scheme == 'default') ? ".headline_outer *," : '') . "
	" . (($scheme == 'default') ? ".headline_outer a:hover," : '') . "
	" . (($scheme == 'default') ? "#slide_top," : '') . "
	{$rule}mark,
	{$rule}form .formError .formErrorContent,
	{$rule}.cmsmasters_button,
	{$rule}.button,
	{$rule}input[type=submit],
	{$rule}input[type=button],
	{$rule}button,
	{$rule}.cmsmasters_button:hover,
	{$rule}.button:hover,
	{$rule}input[type=submit]:hover,
	{$rule}input[type=button]:hover,
	{$rule}button:hover,
	{$rule}table thead th,
	{$rule}.cmsmasters_dropcap.type2,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left_top:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left:before,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top:before,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_border .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:before,
	{$rule}.cmsmasters_social_icon,
	{$rule}.cmsmasters_social_icon:hover,
	{$rule}.cmsmasters_header_search_form input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	{$rule}.headline_outer *,
	{$rule}.headline_outer a:hover,
	{$rule}.cmsmasters_pricing_table .pricing_best_title,
	{$rule}.cmsmasters_notice .notice_close:hover,
	{$rule}.cmsmasters_project_grid .cmsmasters_project_footer > span a,
	{$rule}.cmsmasters_project_grid .cmsmasters_project_footer > span > span,
	{$rule}.cmsmasters_project_grid .cmsmasters_project_footer > span a:hover,
	{$rule}.cmsmasters_project_grid .cmsmasters_project_footer > span a.active,
	{$rule}.cmsmasters_project_puzzle .project_inner,
	{$rule}.cmsmasters_project_puzzle .project_inner *,
	{$rule}.cmsmasters_slider_project .cmsmasters_slider_project_footer > span a,
	{$rule}.cmsmasters_slider_project .cmsmasters_slider_project_footer > span > span,
	{$rule}.cmsmasters_slider_project .cmsmasters_slider_project_footer > span a:hover,
	{$rule}.cmsmasters_slider_project .cmsmasters_slider_project_footer > span a.active,
	{$rule}.headline_outer .headline_inner .cmsmasters_breadcrumbs_inner a,
	{$rule}.cmsmasters_hover_slider .cmsmasters_hover_slider_items .cmsmasters_hover_slider_img_title_wrap,
	{$rule}.cmsmasters_content_slider .cmsmasters_content_slider_img_title_wrap,
	{$rule}.cmsmasters_gallery .cmsmasters_gallery_item .cmsmasters_gallery_img_title_wrap {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}

	{$rule}.cmsmasters_breadcrumbs .cmsmasters_breadcrumbs_inner * {
		color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . ", .85);
	}
	
	{$rule}.cmsmasters_project_puzzle .project_inner a:hover,
	{$rule}.cmsmasters_project_puzzle .project_inner a:hover > span,
	{$rule}.cmsmasters_project_puzzle .project_inner a.active,
	{$rule}.cmsmasters_project_puzzle .project_inner a.active > span {
		color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . ", .8);
	}
	
	" . (($scheme == 'default') ? "body," : '') . "
	" . (($scheme != 'default') ? ".cmsmasters_color_scheme_{$scheme}," : '') . "
	" . (($scheme == 'default') ? ".middle_inner," : '') . "
	" . (($scheme == 'default') ? ".headline_outer," : '') . "
	" . (($scheme == 'footer') ? "#footer," : '') . "
	{$rule}.cmsmasters_img.with_caption,
	{$rule}select,
	{$rule}option,
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=checkbox] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=checkbox] + label:before, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=radio] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=radio] + label:before,
	{$rule}.cmsmasters_header_search_form .cmsmasters_header_search_form_close:before,
	{$rule}.cmsmasters_header_search_form .cmsmasters_header_search_form_close:after,
	{$rule}.cmsmasters_header_search_form .cmsmasters_header_search_form_close:hover:before,
	{$rule}.cmsmasters_header_search_form .cmsmasters_header_search_form_close:hover:after,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left,
	{$rule}.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner:before,
	{$rule}.cmsmasters_notice .notice_close,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_list:after,
	{$rule}.cmsmasters_post_default .cmsmasters_owl_slider .owl-buttons > div > span:before,
	{$rule}.cmsmasters_post_default .cmsmasters_owl_slider .owl-buttons > div > span:after,
	{$rule}.cmsmasters_post_masonry .cmsmasters_owl_slider .owl-buttons > div > span:before,
	{$rule}.cmsmasters_post_masonry .cmsmasters_owl_slider .owl-buttons > div > span:after,
	{$rule}.cmsmasters_post_timeline .cmsmasters_post_info,
	{$rule}.cmsmasters_post_timeline .cmsmasters_owl_slider .owl-buttons > div > span:before,
	{$rule}.cmsmasters_post_timeline .cmsmasters_owl_slider .owl-buttons > div > span:after,
	{$rule}.cmsmasters_open_post .cmsmasters_owl_slider .owl-buttons > div > span:before,
	{$rule}.cmsmasters_open_post .cmsmasters_owl_slider .owl-buttons > div > span:after,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li:hover a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li.current a,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but:hover,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but.current,
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but.reversed,
	{$rule}.ui-widget-content,
	{$rule}.enable_header_side.cmsmasters_header_side #header,
	{$rule}.cmsmasters_open_project .cmsmasters_owl_slider .owl-buttons > div > span:before,
	{$rule}.cmsmasters_open_project .cmsmasters_owl_slider .owl-buttons > div > span:after,
	{$rule}.cmsmasters_content_slider .owl-buttons > div:before,
	{$rule}.cmsmasters_content_slider .owl-buttons > div:after,
	{$rule}#fbuilder input[type=checkbox] + .field_before:before,
	{$rule}#fbuilder input[type=radio] + .field_before:before,
	{$rule}.cmsmasters_hover_slider .cmsmasters_hover_slider_thumbs a:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_content_slider .owl-buttons > div:hover:before,
	{$rule}.cmsmasters_content_slider .owl-buttons > div:hover:after {
		background-color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . ", .5);
	}
	
	{$rule}.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_header_search_form input::-webkit-input-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_header_search_form input:-moz-placeholder {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon_wrap, 
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_bg .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_alternate']) . "
	}
	
	{$rule}fieldset,
	{$rule}fieldset legend,
	{$rule}.cmsmasters_featured_block,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon,
	{$rule}.gallery-item .gallery-icon {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_alternate']) . "
	}
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}.cmsmasters_quotes_slider .cmsmasters_quote_icon:before,
	{$rule}.cmsmasters_open_profile .profile_social_icons_list a,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info .cmsmasters_post_cont_info_sep,
	{$rule}.cmsmasters_open_post .cmsmasters_post_cont_info .cmsmasters_post_cont_info_sep,
	{$rule}.cmsmasters_post_default .cmsmasters_post_cont_info>span+span:before,
	{$rule}.cmsmasters_post_masonry .cmsmasters_post_cont_info>span+span:before,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_author:before,
	{$rule}.cmsmasters_slider_post .cmsmasters_slider_post_category:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li:before,
	{$rule}.owl-pagination .owl-page,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_vert:before,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_vert:after,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_vert span,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_list:before,
	{$rule}.blog.timeline:before {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}.cmsmasters_attach_img .cmsmasters_attach_img_info, 
	{$rule}input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	{$rule}option,
	{$rule}hr,
	{$rule}table tbody th,
	{$rule}table tbody td,
	{$rule}table tfoot td,
	{$rule}.cmsmasters_divider,
	{$rule}.cmsmasters_widget_divider,
	{$rule}.cmsmasters_img.with_caption,
	{$rule}.cmsmasters_icon_wrap .cmsmasters_simple_icon, 
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_top,
	{$rule}.cmsmasters_icon_box.cmsmasters_icon_box_left,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_icon_list_type_block .cmsmasters_icon_list_item,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_bg .cmsmasters_icon_list_icon:after,
	{$rule}.cmsmasters_icon_list_items.cmsmasters_color_type_icon .cmsmasters_icon_list_icon:after, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=checkbox] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=checkbox] + label:before, 
	{$rule}.wpcf7 form.wpcf7-form span.wpcf7-list-item input[type=radio] + span.wpcf7-list-item-label:before, 
	{$rule}.cmsmasters-form-builder .check_parent input[type=radio] + label:before, 
	{$rule}.footer_inner,
	{$rule}.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner:before,
	{$rule}.cmsmasters_pricing_table .cmsmasters_pricing_item_inner,
	{$rule}.cmsmasters_notice,
	{$rule}.cmsmasters_notice .notice_close,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_list:after,
	{$rule}.cmsmasters_quotes_grid .cmsmasters_quotes_list .cmsmasters_quote,
	{$rule}.cmsmasters_toggles .cmsmasters_toggle_title a,
	{$rule}.cmsmasters_toggles.toggles_mode_accordion .cmsmasters_toggle_wrap.current_toggle .cmsmasters_toggle_title a,
	{$rule}.cmsmasters_toggles.toggles_mode_accordion .cmsmasters_toggle_wrap .cmsmasters_toggle_title,
	{$rule}.ui-widget-content,
	{$rule}.cmsmasters_tabs .cmsmasters_tabs_list,
	{$rule}.cmsmasters_archive_type .cmsmasters_archive_item_info,
	{$rule}.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tabs_list,
	{$rule}#fbuilder input[type=checkbox] + .field_before:before,
	{$rule}#fbuilder input[type=radio] + .field_before:before,
	{$rule}.wp-caption,
	{$rule}#fbuilder select {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}textarea {
		background-image:-webkit-linear-gradient(" . $cmsmasters_option['amigos' . '_' . $scheme . '_border'] . " 1px, transparent 1px);
		background-image:-moz-linear-gradient(" . $cmsmasters_option['amigos' . '_' . $scheme . '_border'] . " 1px, transparent 1px);
		background-image:-ms-linear-gradient(" . $cmsmasters_option['amigos' . '_' . $scheme . '_border'] . " 1px, transparent 1px);
		background-image:-o-linear-gradient(" . $cmsmasters_option['amigos' . '_' . $scheme . '_border'] . " 1px, transparent 1px);
		background-image:linear-gradient(" . $cmsmasters_option['amigos' . '_' . $scheme . '_border'] . " 1px, transparent 1px);
		background-position:0 -2px;
	}
	/* Finish Borders Color */
	
	
	/* Start Custom Rules */
	{$rule}::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . ";
	}
	
	{$rule}::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['amigos' . '_' . $scheme . '_color']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	";
	
	
	if ($scheme != 'default') {
		$custom_css .= "
		.cmsmasters_color_scheme_{$scheme}.cmsmasters_row_top_zigzag:before, 
		.cmsmasters_color_scheme_{$scheme}.cmsmasters_row_bot_zigzag:after {
			background-image: -webkit-linear-gradient(135deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%), 
					-webkit-linear-gradient(45deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%);
			background-image: -moz-linear-gradient(135deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%), 
					-moz-linear-gradient(45deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%);
			background-image: -ms-linear-gradient(135deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%), 
					-ms-linear-gradient(45deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%);
			background-image: -o-linear-gradient(135deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%), 
					-o-linear-gradient(45deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%);
			background-image: linear-gradient(315deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%), 
					linear-gradient(45deg, " . $cmsmasters_option['amigos' . '_' . $scheme . '_bg'] . " 25%, transparent 25%);
		}
		";
	}
	
	
	$custom_css .= "
	/* Finish Custom Rules */

/***************** Finish {$title} Color Scheme Rules ******************/


/***************** Start {$title} Button Color Scheme Rules ******************/
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_hover:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_bd_underline {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bd_underline:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_left, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_right, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_top, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_bottom, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_vert, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_hor, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_diag {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_left:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_right:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_top:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_bottom:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_vert:hover, 
	{$rule}.cmsmasters_button.cm.sms_but_bg_expand_hor:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_diag:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_left:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_right:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_top:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_slide_bottom:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_vert:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_hor:after, 
	{$rule}.cmsmasters_button.cmsmasters_but_bg_expand_diag:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_shadow {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_shadow:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_dark_bg, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_light_bg, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_divider {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_dark_bg:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_light_bg:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_divider:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_divider:after {
		" . cmsmasters_color_css('border-right-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:hover:before {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_inverse:hover:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_left, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_right {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_left:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_slide_right:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_left, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_right, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_top, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_bottom {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_left:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_right:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_top:hover, 
	{$rule}.cmsmasters_button.cmsmasters_but_icon_hover_slide_bottom:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_' . $scheme . '_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_' . $scheme . '_bg']) . "
	}

/***************** Finish {$title} Button Color Scheme Rules ******************/


";
	}
	
	
	return apply_filters('amigos_theme_colors_primary_filter', $custom_css);
}

