<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.0
 * 
 * Theme Secondary Color Schemes Rules
 * Created by CMSMasters
 * 
 */


function amigos_theme_colors_secondary() {
	$cmsmasters_option = amigos_get_global_options();
	
	
	$cmsmasters_color_schemes = cmsmasters_color_schemes_list();
	
	
	$custom_css = "/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.0
 * 
 * Theme Secondary Color Schemes Rules
 * Created by CMSMasters
 * 
 */


/***************** Start Header Middle Color Scheme Rules ******************/

	/* Start Header Middle Content Color */
	.header_mid,
	.header_mid input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	.header_mid textarea,
	.header_mid select,
	.header_mid option {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_mid_color']) . "
	}
	/* Finish Header Middle Content Color */
	
	
	/* Start Header Middle Primary Color */
	.header_mid a {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_mid_link']) . "
	}
	
	.header_mid .button:hover,
	.header_mid input[type=submit]:hover,
	.header_mid input[type=button]:hover,
	.header_mid button:hover,
	.header_mid .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but:before,
	.header_mid .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but:after,
	.header_mid .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but > span {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_mid_link']) . "
	}
	/* Finish Header Middle Primary Color */
	
	
	/* Start Header Middle Rollover Color */
	.header_mid a:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_mid_hover']) . "
	}
	
	.header_mid .button,
	.header_mid input[type=submit],
	.header_mid input[type=button],
	.header_mid button {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_mid_hover']) . "
	}
	
	.header_mid input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]):focus,
	.header_mid textarea:focus,
	.header_mid select:focus {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_mid_hover']) . "
	}
	/* Finish Header Middle Rollover Color */
	
	
	/* Start Header Middle Background Color */
	.header_mid .button, 
	.header_mid input[type=submit], 
	.header_mid input[type=button], 
	.header_mid button, 
	.header_mid .button:hover, 
	.header_mid input[type=submit]:hover, 
	.header_mid input[type=button]:hover, 
	.header_mid button:hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_mid_bg']) . "
	}
	
	.header_mid,
	.header_mid input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	.header_mid textarea,
	.header_mid select,
	.header_mid option {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_mid_bg']) . "
	}
	/* Finish Header Middle Background Color */
	
	
	/* Start Header Middle Borders Color */
	.header_mid input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	.header_mid textarea,
	.header_mid select,
	.header_mid option,
	.cmsmasters_default_nav .header_mid.header_mid_scroll,
	.enable_header_side.cmsmasters_header_side .header_mid,
	.enable_header_side.cmsmasters_header_side #footer {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_mid_border']) . "
	}
	/* Finish Header Middle Borders Color */
	
	
	/* Start Header Middle Custom Rules */
	.header_mid ::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['amigos' . '_header_mid_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_mid_hover']) . "
	}
	
	.header_mid ::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['amigos' . '_header_mid_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_mid_bg']) . "
	}
	/* Finish Header Middle Custom Rules */

/***************** Finish Header Middle Color Scheme Rules ******************/



/***************** Start Navigation Color Scheme Rules ******************/

/*********** Start Default Navigation Color ***********/
	/* Start Navigation Title Link Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_title_link']) . "
		}
	}
	/* Finish Navigation Title Link Color */
	
	
	/* Start Navigation Title Link Hover Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li > a:hover,
		.enable_header_default ul.navigation > li:hover > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_title_link_hover']) . "
		}
	}
	/* Finish Navigation Title Link Hover Color */
	
	
	/* Start Navigation Title Link Current Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li.menu-item.current-menu-item > a,
		.enable_header_default ul.navigation > li.menu-item.current-menu-ancestor > a,
		.enable_header_default ul.navigation > li.current_page_item > a,
		.enable_header_default ul.navigation > li.current_page_ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_title_link_current']) . "
		}
		
		.enable_header_default ul.navigation > li.current-menu-item > a > .nav_item_wrap,
		.enable_header_default ul.navigation > li.current-menu-ancestor > a > .nav_item_wrap,
		.enable_header_default ul.navigation > li.current_page_item > a > .nav_item_wrap,
		.enable_header_default ul.navigation > li.current_page_ancestor  > a > .nav_item_wrap {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_title_link_current']) . "
		}
	}
	/* Finish Navigation Title Link Current Color */
	
	
	/* Start Navigation Title Link Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_title_link_bg']) . "
		}
	}
	/* Finish Navigation Title Link Background Color */
	
	
	/* Start Navigation Title Link Hover Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li > a:hover,
		.enable_header_default ul.navigation > li:hover > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_title_link_bg_hover']) . "
		}
	}
	/* Finish Navigation Title Link Hover Background Color */
	
	
	/* Start Navigation Title Link Current Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li.menu-item.current-menu-item > a,
		.enable_header_default ul.navigation > li.menu-item.current-menu-ancestor > a,
		.enable_header_default ul.navigation > li.menu-item.current_page_item > a,
		.enable_header_default ul.navigation > li.menu-item.current_page_ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_title_link_bg_current']) . "
		}
	}
	/* Finish Navigation Title Link Current Background Color */
	
	
	/* Start Navigation Title Link Border Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default ul.navigation > li > a {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_title_link_border']) . "
		}
	}
	/* Finish Navigation Title Link Border Color */
	
	
	/* Start Navigation Dropdown Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default .header_mid.header_mid_scroll,
		.enable_header_default .header_top.header_top_scroll {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_bg']) . "
		}
	}
	/* Finish Navigation Dropdown Background Color */
	
	
	/* Start Navigation Dropdown Link Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li > a,
		.enable_header_default .header_mid.header_mid_scroll .mid_search_but_wrap .mid_search_but {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
		}
		
		.enable_header_default .header_mid.header_mid_scroll .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but:before,
		.enable_header_default .header_mid.header_mid_scroll .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but:after,
		.enable_header_default .header_mid.header_mid_scroll .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but > span {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
		}
	}
	
	@media only screen and (max-width: 1024px) {
		.enable_header_default .header_mid .mid_search_but_wrap .mid_search_but {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
		}
		
		.enable_header_default .header_mid .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but:before,
		.enable_header_default .header_mid .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but:after,
		.enable_header_default .header_mid .resp_mid_nav_wrap .resp_mid_nav .resp_mid_nav_but > span {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
		}
	}
	/* Finish Navigation Dropdown Link Color */
	
	
	/* Start Navigation Dropdown Link Hover Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li > a:hover,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.menu-item.current-menu-item > a,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.current-menu-ancestor > a,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.menu-item.current_page_item > a,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.current_page_ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
		}
		
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.current-menu-item > a > .nav_item_wrap,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.current-menu-ancestor > a > .nav_item_wrap,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.current_page_item > a > .nav_item_wrap,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.current_page_ancestor > a > .nav_item_wrap,
		.enable_header_default .header_mid ul.navigation > li li.current-menu-item > a > .nav_item_wrap,
		.enable_header_default .header_mid ul.navigation > li li.current-menu-ancestor > a > .nav_item_wrap,
		.enable_header_default .header_mid ul.navigation > li li.current_page_item > a > .nav_item_wrap,
		.enable_header_default .header_mid ul.navigation > li li.current_page_ancestor > a > .nav_item_wrap {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
		}
	}
	/* Finish Navigation Dropdown Link Hover Color */
	
	
	/* Start Navigation Dropdown Link Hover Highlight Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li > a:hover,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.menu-item.current-menu-item > a,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.menu-item.current-menu-ancestor > a,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.menu-item.current_page_item > a,
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li.menu-item.current_page_ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_highlight']) . "
		}
	}
	/* Finish Navigation Dropdown Link Hover Highlight Color */
	
	
	/* Start Navigation Dropdown Link Border Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_default .header_mid.header_mid_scroll ul.navigation > li > a {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_border']) . "
		}
	}
	/* Finish Navigation Dropdown Link Border Color */

/*********** Finish Default Navigation Color ***********/


/*********** Start Side Navigation Color ***********/
	
	/* Start Navigation Title Link Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_title_link']) . "
		}
	}
	/* Finish Navigation Title Link Color */
	
	
	/* Start Navigation Title Link Hover Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li > a:hover,
		.enable_header_side ul.navigation > li:hover > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_title_link_hover']) . "
		}
	}
	/* Finish Navigation Title Link Hover Color */
	
	
	/* Start Navigation Title Link Current Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li.menu-item.current-menu-item > a,
		.enable_header_side ul.navigation > li.menu-item.current-menu-ancestor > a,
		.enable_header_side ul.navigation > li.menu-item.current_page_item > a,
		.enable_header_side ul.navigation > li.menu-item.current_page_ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_title_link_current']) . "
		}
		
		.enable_header_side #header .navigation > li.current-menu-item > a > .nav_item_wrap,
		.enable_header_side #header .navigation > li.current-menu-ancestor > a > .nav_item_wrap,
		.enable_header_side #header .navigation > li.current_page_item > a > .nav_item_wrap,
		.enable_header_side #header .navigation > li.current_page_ancestor > a > .nav_item_wrap {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_title_link_current']) . "
		}
	}
	/* Finish Navigation Title Link Current Color */
	
	
	/* Start Navigation Title Link Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_title_link_bg']) . "
		}
	}
	/* Finish Navigation Title Link Background Color */
	
	
	/* Start Navigation Title Link Hover Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li > a:hover,
		.enable_header_side ul.navigation > li:hover > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_title_link_bg_hover']) . "
		}
	}
	/* Finish Navigation Title Link Hover Background Color */
	
	
	/* Start Navigation Title Link Current Background Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li.menu-item.current-menu-item > a,
		.enable_header_side ul.navigation > li.menu-item.current-menu-ancestor > a,
		.enable_header_side ul.navigation > li.menu-item.current_page_item > a,
		.enable_header_side ul.navigation > li.menu-item.current_page_ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_title_link_bg_current']) . "
		}
	}
	/* Finish Navigation Title Link Current Background Color */
	
	
	/* Start Navigation Title Link Border Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side ul.navigation > li > a {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_title_link_border']) . "
		}
	}
	/* Finish Navigation Title Link Border Color */
	
	
	/* Start Navigation Dropdown Link Hover Color */
	@media only screen and (min-width: 1025px) {
		.enable_header_side #header .navigation > li li.current-menu-item > a > .nav_item_wrap,
		.enable_header_side #header .navigation > li li.current-menu-ancestor > a > .nav_item_wrap,
		.enable_header_side #header .navigation > li li.current_page_item > a > .nav_item_wrap,
		.enable_header_side #header .navigation > li li.current_page_ancestor > a > .nav_item_wrap {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
		}
	}
	/* Finish Navigation Dropdown Link Hover Color */
	
/*********** Finish Side Navigation Color ***********/


/*********** Start Small Navigation Color ***********/
	
	/* Start Navigation Dropdown Background Color */
	ul.navigation ul, 
	ul.navigation .menu-item-mega-container {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_bg']) . "
	}
	
	@media only screen and (max-width: 1024px) {
		.header_mid,
		ul.navigation {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_bg']) . "
		}
	}
	/* Finish Navigation Dropdown Background Color */
	
	
	/* Start Navigation Dropdown Border Color */
	ul.navigation ul, 
	ul.navigation .menu-item-mega-container {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_border']) . "
	}
	/* Finish Navigation Dropdown Border Color */
	
	
	/* Start Navigation Dropdown Link Color */
	.navigation > li li a {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
	}
	
	@media only screen and (max-width: 1024px) {
		ul.navigation > li > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
		}
	}

	@media only screen and (min-width: 1025px) {
		.navigation div.menu-item-mega-container > ul > li > a:not([href]):hover, 
		.navigation div.menu-item-mega-container > ul > li > a:not([href]):hover .nav_subtitle {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link']) . "
		}
	}
	/* Finish Navigation Dropdown Link Color */
	
	
	/* Start Navigation Dropdown Link Hover Color */
	.navigation > li li > a:hover,
	.navigation > li li:hover > a,
	.navigation > li li.current-menu-item > a,
	.navigation > li li.current-menu-ancestor > a,
	.navigation > li li.current_page_item > a,
	.navigation > li li.current_page_ancestor > a {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.navigation li > ul li:hover > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
		}
	}
	
	@media only screen and (max-width: 1024px) {
		ul.navigation > li > a:hover,
		ul.navigation > li:hover > a,
		.navigation > li.current-menu-item > a,
		.navigation > li.current-menu-ancestor > a,
		.navigation > li.current_page_item > a,
		.navigation > li.current_page_ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
		}
		
		#header .navigation li.current-menu-item > a > .nav_item_wrap,
		#header .navigation li.current-menu-ancestor > a > .nav_item_wrap,
		#header .navigation li.current_page_item > a > .nav_item_wrap,
		#header .navigation li.current_page_ancestor > a > .nav_item_wrap {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_hover']) . "
		}
	}
	/* Finish Navigation Dropdown Link Hover Color */
	
	
	/* Start Navigation Dropdown Link Hover Highlight Color */
	.navigation > li li > a:hover,
	.navigation > li li:hover > a,
	.navigation > li li.current-menu-item > a,
	.navigation > li li.current-menu-ancestor > a,
	.navigation > li li.current_page_item > a,
	.navigation > li li.current_page_ancestor > a {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_highlight']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.navigation li > ul li:hover > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_highlight']) . "
		}
	}
	
	@media only screen and (max-width: 1024px) {
		ul.navigation > li > a:hover,
		ul.navigation > li:hover > a,
		.navigation > li.current-menu-item > a,
		.navigation > li.current-menu-ancestor > a,
		.navigation > li.current_page_item > a,
		.navigation > li.current_page_ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_highlight']) . "
		}
		
		.navigation div.menu-item-mega-container > ul > li > a:not([href]):hover {
			background-color:transparent;
		}
	}
	/* Finish Navigation Dropdown Link Hover Highlight Color */
	
	
	/* Start Navigation Dropdown Link Border Color */
	.navigation > li li a {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_border']) . "
	}
	
	@media only screen and (max-width: 1024px) {
		.navigation,
		ul.navigation > li,
		.navigation > li li {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_navigation_dropdown_link_border']) . "
		}
	}
	/* Finish Navigation Dropdown Link Border Color */

/*********** Finish Small Navigation Color ***********/

/***************** Finish Navigation Color Scheme Rules ******************/



/***************** Start Header Top Color Scheme Rules ******************/

	/* Start Header Top Content Color */
	.header_top {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_color']) . "
	}
	/* Finish Header Top Content Color */
	
	
	/* Start Header Top Primary Color */
	.header_top a,
	.header_top .header_top_but:hover,
	.header_top .header_top_but.opened {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_link']) . "
	}
	
	.header_top .responsive_top_nav > span,
	.header_top .responsive_top_nav > span:before,
	.header_top .responsive_top_nav > span:after,
	.header_top .responsive_top_nav:hover > span:before,
	.header_top .responsive_top_nav:hover > span:after,
	.header_top .responsive_top_nav.active > span:before,
	.header_top .responsive_top_nav.active > span:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_link']) . "
	}
	/* Finish Header Top Primary Color */
	
	
	/* Start Header Top Rollover Color */
	.header_top a:hover,
	.header_top .header_top_but {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_hover']) . "
	}
	/* Finish Header Top Rollover Color */
	
	
	/* Start Header Top Background Color */
	.header_top {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_bg']) . "
	}
	/* Finish Header Top Background Color */
	
	
	/* Start Header Top Borders Color */
	.header_top .header_top_outer,
	.header_top .header_top_but,
	.header_top .top_nav_wrap {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_top_border']) . "
	}
	/* Finish Header Top Borders Color */
	
	
	/* Start Header Top Custom Rules */
	.header_top ::selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['amigos' . '_header_top_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_bg']) . "
	}
	
	.header_top ::-moz-selection {
		" . cmsmasters_color_css('background', $cmsmasters_option['amigos' . '_header_top_link']) . "
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_bg']) . "
	}
	/* Finish Header Top Custom Rules */

/***************** Finish Header Top Color Scheme Rules ******************/



/***************** Start Header Top Navigation Color Scheme Rules ******************/

	/* Start Header Top Navigation Title Link Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_title_link']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Color */
	
	
	/* Start Header Top Navigation Title Link Hover Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a:hover,
		ul.top_line_nav > li:hover > a,
		ul.top_line_nav > li.current-menu-item > a,
		ul.top_line_nav > li.current-menu-ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_title_link_hover']) . "
		}
		
		ul.top_line_nav > li.current-menu-item > a > .nav_item_wrap:after,
		ul.top_line_nav > li.current-menu-ancestor > a > .nav_item_wrap:after {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_title_link_hover']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Hover Color */
	
	
	/* Start Header Top Navigation Title Link Background Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_title_link_bg']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Background Color */
	
	
	/* Start Header Top Navigation Title Link Hover Background Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li > a:hover,
		ul.top_line_nav > li:hover > a,
		ul.top_line_nav > li.current-menu-item > a,
		ul.top_line_nav > li.current-menu-ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_title_link_bg_hover']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Hover Background Color */
	
	
	/* Start Header Top Navigation Title Link Border Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav > li {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_top_title_link_border']) . "
		}
	}
	/* Finish Header Top Navigation Title Link Border Color */
	
	
	/* Start Header Top Navigation Dropdown Background Color */
	@media only screen and (max-width: 1024px) {
		ul.top_line_nav {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_dropdown_bg']) . "
		}
	}
	
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_dropdown_bg']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Background Color */
	
	
	/* Start Header Top Navigation Dropdown Border Color */
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_top_dropdown_border']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Border Color */
	
	
	/* Start Header Top Navigation Dropdown Link Color */
	.top_line_nav li a {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_dropdown_link']) . "
	}
	/* Finish Header Top Navigation Dropdown Link Color */
	
	
	/* Start Header Top Navigation Dropdown Link Hover Color */
	.top_line_nav li > a:hover,
	.top_line_nav li.current-menu-item > a {
		" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_hover']) . "
	}
	
	.top_line_nav li.current-menu-item > a > .nav_item_wrap:after {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_hover']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul li:hover > a,
		ul.top_line_nav ul li.current-menu-ancestor > a {
			" . cmsmasters_color_css('color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_hover']) . "
		}
		
		ul.top_line_nav ul li.current-menu-ancestor > a > .nav_item_wrap:after {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_hover']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Link Hover Color */
	
	
	/* Start Header Top Navigation Dropdown Link Hover Highlight Color */
	.top_line_nav li > a:hover,
	.top_line_nav li.current-menu-item > a {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_highlight']) . "
	}
	
	@media only screen and (min-width: 1025px) {
		ul.top_line_nav ul li:hover > a,
		ul.top_line_nav ul li.current-menu-ancestor > a {
			" . cmsmasters_color_css('background-color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_highlight']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Link Hover Highlight Color */
	
	
	/* Start Header Top Navigation Dropdown Link Border Color */
	@media only screen and (min-width: 1025px) {
		.top_line_nav li > a {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_border']) . "
		}
	}
	
	@media only screen and (max-width: 1024px) {
		.top_line_nav li {
			" . cmsmasters_color_css('border-color', $cmsmasters_option['amigos' . '_header_top_dropdown_link_border']) . "
		}
	}
	/* Finish Header Top Navigation Dropdown Link Border Color */

/***************** Finish Header Top Navigation Color Scheme Rules ******************/

";
	
	
	return apply_filters('amigos_theme_colors_secondary_filter', $custom_css);
}

