<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.2
 * 
 * Theme Fonts Rules
 * Created by CMSMasters
 * 
 */


function amigos_theme_fonts() {
	$cmsmasters_option = amigos_get_global_options();
	
	
	$custom_css = "/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.0
 * 
 * Theme Fonts Rules
 * Created by CMSMasters
 * 
 */


/***************** Start Theme Font Styles ******************/

	/* Start Content Font */
	body,
	.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap,
	.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap *,
	.cmsmasters_archive_type .cmsmasters_archive_item_info,
	.cmsmasters_archive_type .cmsmasters_archive_item_info a,
	.cmsmasters_quotes_slider .cmsmasters_quote_title,
	.cmsmasters_profile_horizontal .cmsmasters_profile_header .cmsmasters_profile_subtitle, 
	.cmsmasters_quotes_grid .cmsmasters_quote_content {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_content_font_google_font']) . $cmsmasters_option['amigos' . '_content_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_content_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_content_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_content_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_content_font_font_style'] . ";
	}

	.cmsmasters_profile_horizontal .cmsmasters_profile_header .cmsmasters_profile_subtitle {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_content_font_font_size'] - 2) . "px;
		text-transform: none;
	}

	.cmsmasters_quotes_slider .cmsmasters_quote_title {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_content_font_font_size'] + 1) . "px;
		text-transform: uppercase;
	}
	
	.cmsmasters_icon_list_items li:before {
		line-height:" . $cmsmasters_option['amigos' . '_content_font_line_height'] . "px;
	}
	
	.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content,
	.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_content_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_content_font_line_height'] + 2) . "px;
	}
	
	table tbody th,
	table tbody td,
	.cmsmasters_pricing_table .pricing_best_title,
	.cmsmasters_post_default .cmsmasters_post_date,
	.cmsmasters_open_post .cmsmasters_post_date,
	.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap,
	.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap *,
	.post_nav > span .sub,
	.cmsmasters_open_profile .profile_details_item_desc,
	.cmsmasters_open_profile .profile_details_item_desc a,
	.cmsmasters_open_profile .profile_features_item_desc,
	.cmsmasters_open_profile .profile_features_item_desc a,
	.cmsmasters_open_project .project_details_item_desc,
	.cmsmasters_open_project .project_details_item_desc a,
	.cmsmasters_open_project .project_details_item_desc,
	.cmsmasters_open_project .project_details_item_desc a,
	.cmsmasters_hover_slider .cmsmasters_hover_slider_img_title_wrap .cmsmasters_hover_slider_img_caption,
	.cmsmasters_content_slider .cmsmasters_content_slider_img_title_wrap .cmsmasters_content_slider_img_caption,
	.cmsmasters_archive_type .cmsmasters_archive_item_type,
	.cmsmasters_archive_type .cmsmasters_archive_item_info,
	.cmsmasters_archive_type .cmsmasters_archive_item_info a,
	.cmsmasters_gallery .cmsmasters_gallery_item .cmsmasters_gallery_img_title_wrap > span.cmsmasters_gallery_img_caption,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li > p {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_content_font_font_size'] - 1) . "px;
	}
	
	.header_top .meta_wrap > *,
	.headline_outer .headline_inner .cmsmasters_breadcrumbs_inner,
	.cmsmasters_slider_post .cmsmasters_slider_post_date,
	.widget_recent_entries .post-date,
	.cmsmasters_slider_post .cmsmasters_slider_post_author,
	.cmsmasters_slider_post .cmsmasters_slider_post_author a,
	.cmsmasters_slider_post .cmsmasters_slider_post_category,
	.cmsmasters_slider_post .cmsmasters_slider_post_category a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_content_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_content_font_line_height'] - 2) . "px;
	}

	#page #fbuilder .fields input.codepeoplecalculatedfield {
		font-weight: bold;
	}
	/* Finish Content Font */


	/* Start Link Font */
	a,
	.subpage_nav > strong,
	.subpage_nav > span,
	.subpage_nav > a,
	.subpage_nav > span:not([class]),
	.cmsmasters_post_default .cmsmasters_post_cont_info,
	.cmsmasters_post_masonry .cmsmasters_post_cont_info,
	.cmsmasters_post_timeline .cmsmasters_post_cont_info,
	.cmsmasters_open_post .cmsmasters_post_cont_info,
	.cmsmasters_project_grid .cmsmasters_project_cont_info,
	.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a,
	.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but,
	.cmsmasters_project_puzzle .cmsmasters_project_cont_info,
	.cmsmasters_project_puzzle .cmsmasters_project_cont_info a,
	.comment-respond .comment-reply-title small a,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tabs_list_item a,
	.cmsmasters_post_default .cmsmasters_post_cont_info > span,
	.cmsmasters_post_default .cmsmasters_post_cont_info > span a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_link_font_google_font']) . $cmsmasters_option['amigos' . '_link_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_link_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_link_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_link_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_link_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_link_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_link_font_text_decoration'] . ";
	}

	.cmsmasters_slider_project .cmsmasters_slider_project_cont_info .cmsmasters_slider_project_category a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_link_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] + 2) . "px;
	}

	.cmsmasters_post_default .cmsmasters_post_footer .cmsmasters_post_read_more {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_link_font_font_size']) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] + 2) . "px;
	}

	
	.cmsmasters_post_default .cmsmasters_post_cont_info,
	.cmsmasters_post_default .cmsmasters_post_cont_info a,
	.cmsmasters_post_default .cmsmasters_post_read_more,
	.cmsmasters_open_post .cmsmasters_post_cont_info,
	.cmsmasters_open_post .cmsmasters_post_cont_info a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_link_font_font_size'] + 1) . "px;
	}

	
	table tbody th a,
	table tbody td a,
	.cmsmasters_post_masonry .cmsmasters_post_cont_info,
	.cmsmasters_post_masonry .cmsmasters_post_cont_info a,
	.cmsmasters_post_timeline .cmsmasters_post_cont_info,
	.cmsmasters_post_timeline .cmsmasters_post_cont_info a,
	.about_author .about_author_cont > a,
	.cmsmasters_project_grid .cmsmasters_project_cont_info,
	.cmsmasters_project_grid .cmsmasters_project_cont_info a,
	.cmsmasters_project_puzzle .cmsmasters_project_cont_info,
	.cmsmasters_project_puzzle .cmsmasters_project_cont_info a,
	.cmsmasters_slider_project .cmsmasters_slider_project_cont_info,
	.cmsmasters_slider_project .cmsmasters_slider_project_cont_info a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_link_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] - 1) . "px;
	}

	.cmsmasters_slider_post .cmsmasters_slider_post_read_more {
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] + 2) . "px;
	}
	
	.headline_outer .headline_inner .cmsmasters_breadcrumbs_inner a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_link_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] - 2) . "px;
	}
	
	.cmsmasters_post_default .cmsmasters_post_info * {
		line-height:" . $cmsmasters_option['amigos' . '_link_font_line_height'] . "px;
	}
	
	.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a {
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] - 4) . "px;
	}
	
	.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but,
	.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but:before {
		line-height:" . ((int) $cmsmasters_option['amigos' . '_link_font_line_height'] + 2) . "px;
	}
	
	a:hover {
		text-decoration:" . $cmsmasters_option['amigos' . '_link_hover_decoration'] . ";
	}
	/* Finish Link Font */


	/* Start Navigation Title Font */
	.navigation > li > a,
	.top_line_nav > li > a,
	.footer_nav > li > a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_nav_title_font_google_font']) . $cmsmasters_option['amigos' . '_nav_title_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_nav_title_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_nav_title_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_nav_title_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_nav_title_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_nav_title_font_text_transform'] . ";
	}
	
	.top_line_nav > li > a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_nav_title_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_nav_title_font_line_height'] - 2) . "px;
	}
	
	@media only screen and (max-width: 1024px) {
		#header .header_mid .navigation .cmsmasters_resp_nav_toggle {
			line-height:" . ((int) $cmsmasters_option['amigos' . '_nav_title_font_line_height'] + 14) . "px;
			height:" . ((int) $cmsmasters_option['amigos' . '_nav_title_font_line_height'] + 14) . "px;
			width: 50px;
		}
	}
	/* Finish Navigation Title Font */


	/* Start Navigation Dropdown Font */
	.navigation ul li a,
	.top_line_nav ul li a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_nav_dropdown_font_google_font']) . $cmsmasters_option['amigos' . '_nav_dropdown_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_nav_dropdown_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_nav_dropdown_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_nav_dropdown_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_nav_dropdown_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_nav_dropdown_font_text_transform'] . ";
	}
	
	.top_line_nav ul li a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_nav_dropdown_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_nav_dropdown_font_line_height'] - 2) . "px;
	}
	/* Finish Navigation Dropdown Font */


	/* Start H1 Font */
	h1,
	h1 a,
	.logo .title,
	.cmsmasters_pricing_table .cmsmasters_price_wrap,
	.cmsmasters_quotes_slider .cmsmasters_quote_icon:before,
	.cmsmasters_post_timeline .cmsmasters_post_date .cmsmasters_day {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h1_font_google_font']) . $cmsmasters_option['amigos' . '_h1_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_h1_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_h1_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_h1_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h1_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_h1_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_h1_font_text_decoration'] . ";
	}
	
	.cmsmasters_icon_list_items.cmsmasters_icon_list_icon_type_number .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:before,
	.cmsmasters_icon_box.box_icon_type_number:before,
	.cmsmasters_icon_box.cmsmasters_icon_heading_left.box_icon_type_number .icon_box_heading:before {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h1_font_google_font']) . $cmsmasters_option['amigos' . '_h1_font_system_font'] . ";
		font-weight:" . $cmsmasters_option['amigos' . '_h1_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h1_font_font_style'] . ";
	}
	
	.cmsmasters_quotes_slider .cmsmasters_quote_icon:before {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] + 100) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] + 80) . "px;
		text-transform:none;
	}

	.headline_outer .headline_inner .headline_text .entry-title {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h1_font_font_size'] + 4) . "px;
	}
	
	@media only screen and (max-width: 767px) {
		.cmsmasters_post_timeline .cmsmasters_post_date .cmsmasters_day {
			font-size:" . ((int) $cmsmasters_option['amigos' . '_h1_font_font_size'] - 4) . "px;
			line-height:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] - 10) . "px;
		}
		
		.headline_outer .headline_inner .headline_text .entry-title {
			font-size:" . ((int) $cmsmasters_option['amigos' . '_h1_font_font_size'] - 16) . "px;
		}
	}
	
	.cmsmasters_pricing_table .cmsmasters_price_wrap {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] - 15) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] - 15) . "px;
	}
	
	.cmsmasters_dropcap.type1 {
		font-size:49px; /* static */
	}
	
	.cmsmasters_dropcap.type2 {
		font-size:26px; /* static */
	}
	
	.headline_outer .headline_inner .headline_icon:before {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] - 30) . "px;
	}
	
	.headline_outer .headline_inner .headline_icon {
		padding-top:" . ((int) $cmsmasters_option['amigos' . '_h1_font_line_height'] - 34) . "px;
	}
	/* Finish H1 Font */


	/* Start H2 Font */
	h2,
	h2 a,
	.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > a,
	.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap,
	.cmsmasters_post_default .cmsmasters_post_header .cmsmasters_post_title,
	.cmsmasters_post_default .cmsmasters_post_header .cmsmasters_post_title a,
	.cmsmasters_pricing_table .pricing_title {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h2_font_google_font']) . $cmsmasters_option['amigos' . '_h2_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_h2_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_h2_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_h2_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h2_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_h2_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_h2_font_text_decoration'] . ";
	}
	
	.cmsmasters_pricing_table .pricing_title,
	.error .error_subtitle {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h2_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h2_font_line_height'] - 2) . "px;
	}
	
	.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h2_font_font_size'] + 16) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h2_font_line_height'] + 16) . "px;
	}
	/* Finish H2 Font */


	/* Start H3 Font */
	h3,
	h3 a,
	.cmsmasters_toggles .cmsmasters_toggle_title a,
	.cmsmasters_tabs .cmsmasters_tabs_list_item a,
	.post_comments .post_comments_title,
	.widget .widgettitle,
	.cmsmasters_post_masonry .cmsmasters_post_header .cmsmasters_post_title,
	.cmsmasters_post_masonry .cmsmasters_post_header .cmsmasters_post_title a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h3_font_google_font']) . $cmsmasters_option['amigos' . '_h3_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_h3_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_h3_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_h3_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h3_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_h3_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_h3_font_text_decoration'] . ";
	}
	
	.about_author .about_author_title,
	.post_comments .post_comments_title,
	.comment-respond .comment-reply-title,
	.cmsmasters_single_slider .cmsmasters_single_slider_title,
	.cmsmasters_open_profile .profile_details_title,
	.cmsmasters_open_profile .profile_features_title,
	.cmsmasters_open_profile .profile_social_icons_title,
	.cmsmasters_open_project .project_details_title,
	.cmsmasters_open_project .project_features_title {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h3_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h3_font_line_height'] + 2) . "px;
	}
	/* Finish H3 Font */


	/* Start H4 Font */
	h4,
	h4 a,
	.cmsmasters_hover_slider .cmsmasters_hover_slider_img_title_wrap .cmsmasters_hover_slider_img_title,
	.cmsmasters_content_slider .cmsmasters_content_slider_img_title_wrap .cmsmasters_content_slider_img_title,
	.cmsmasters_gallery .cmsmasters_gallery_item .cmsmasters_gallery_img_title_wrap .cmsmasters_gallery_img_title {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h4_font_google_font']) . $cmsmasters_option['amigos' . '_h4_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_h4_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_h4_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_h4_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h4_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_h4_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_h4_font_text_decoration'] . ";
		letter-spacing:0.1em;
	}
	
	.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap,
	.cmsmasters_comment_item .cmsmasters_comment_item_date_reply_wrap * {
		line-height:" . $cmsmasters_option['amigos' . '_h4_font_line_height'] . "px;
	}
	/* Finish H4 Font */


	/* Start H5 Font */
	h5,
	h5 a,
	table thead th,
	.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > a,
	.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > a,
	.post_nav > span a,
	.widget_calendar #wp-calendar th,
	.cmsmasters_slider_project .cmsmasters_slider_project_header .cmsmasters_slider_project_title,
	.cmsmasters_slider_project .cmsmasters_slider_project_header .cmsmasters_slider_project_title a,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_lpr_tabs_cont > a,
	.cmsmasters_toggles .cmsmasters_toggle_title a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h5_font_google_font']) . $cmsmasters_option['amigos' . '_h5_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_h5_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_h5_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_h5_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h5_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_h5_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_h5_font_text_decoration'] . ";
		letter-spacing:0.1em;
	}

	.cmsmasters_slider_project .cmsmasters_slider_project_header .cmsmasters_slider_project_title a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h5_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h5_font_line_height'] + 4) . "px;
		letter-spacing:0.1em;
	}

	.cmsmasters_toggles .cmsmasters_toggle_title a {
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h5_font_line_height'] + 4) . "px;
		letter-spacing:0.1em;
	}
	
	@media only screen and (max-width: 600px) {
		.post_nav > span > span.cmsmasters_nav_arrow {
			height:" . $cmsmasters_option['amigos' . '_h5_font_line_height'] . "px;
		}
	}
	
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_lpr_tabs_cont > a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h5_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h5_font_line_height'] - 6) . "px;
		letter-spacing:0.1em;
	}
	
	.widget_calendar #wp-calendar th {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h5_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h5_font_line_height'] - 4) . "px;
		letter-spacing:0.1em;
	}
	/* Finish H5 Font */


	/* Start H6 Font */
	h6,
	h6 a,
	table tfoot td,
	.headline_outer .headline_inner .entry-subtitle,
	.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_title,
	.cmsmasters_pricing_table .cmsmasters_period,
	.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap,
	.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap *,
	.cmsmasters_quotes_grid .cmsmasters_quote_subtitle_wrap,
	.cmsmasters_quotes_grid .cmsmasters_quote_subtitle_wrap *,
	.cmsmasters_twitter_wrap .published,
	.cmsmasters_post_timeline .cmsmasters_post_date .cmsmasters_mon_year,
	.cmsmasters_comment_item .cmsmasters_comment_item_avatar_wrap .comment-edit-link,
	.share_posts a,
	.cmsmasters_open_profile .profile_details_item_title,
	.cmsmasters_open_profile .profile_features_item_title,
	.cmsmasters_open_project .project_details_item_title,
	.cmsmasters_open_project .project_features_item_title,
	#page #fbuilder .fields > label,
	.widget_custom_twitter_entries .tweet_time,
	.widget_calendar #wp-calendar caption,
	.widget_calendar #wp-calendar tfoot *,
	.widget_categories a,
	.widget_archive a,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab .published {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_h6_font_google_font']) . $cmsmasters_option['amigos' . '_h6_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_h6_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_h6_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_h6_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_h6_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_h6_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['amigos' . '_h6_font_text_decoration'] . ";
		letter-spacing:0.1em;
	}
	
	.cmsmasters_twitter_wrap .twr_icon,
	.cmsmasters_twitter_wrap .published {
		height:" . $cmsmasters_option['amigos' . '_h6_font_line_height'] . "px;
		letter-spacing:0.1em;
	}
	
	.cmsmasters_twitter_wrap .twr_icon,
	.cmsmasters_twitter_wrap .twr_icon:before,
	.cmsmasters_open_profile .profile_details_item_desc,
	.cmsmasters_open_profile .profile_details_item_desc a,
	.cmsmasters_open_profile .profile_features_item_desc,
	.cmsmasters_open_profile .profile_features_item_desc a,
	.cmsmasters_open_project .project_details_item_desc,
	.cmsmasters_open_project .project_details_item_desc a,
	.cmsmasters_open_project .project_details_item_desc,
	.cmsmasters_open_project .project_details_item_desc a {
		line-height:" . $cmsmasters_option['amigos' . '_h6_font_line_height'] . "px;
	}
	
	.headline_outer .headline_inner .entry-subtitle {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h6_font_font_size'] + 6) . "px;
		line-height:" . ((int) $cmsmasters_option['amigos' . '_h6_font_line_height'] + 6) . "px;
		letter-spacing:0.1em;
	}
	
	.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap,
	.cmsmasters_quotes_slider .cmsmasters_quote_subtitle_wrap *,
	.cmsmasters_post_timeline .cmsmasters_post_date .cmsmasters_mon_year,
	.widget_archive a {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h6_font_font_size'] - 1) . "px;
		letter-spacing:0.1em;
	}
	
	.cmsmasters_comment_item .cmsmasters_comment_item_avatar_wrap .comment-edit-link,
	.widget_calendar #wp-calendar caption,
	.widget_calendar #wp-calendar tfoot *,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab .published {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_h6_font_font_size'] - 2) . "px;
		letter-spacing:0.1em;
	}
	/* Finish H6 Font */


	/* Start Button Font */
	.cmsmasters_button,
	.button,
	input[type=submit],
	input[type=button],
	button,
	.cmsmasters_quotes_slider .cmsmasters_quote_subtitle,
	.cmsmasters_quotes_slider .cmsmasters_quote_site a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_button_font_google_font']) . $cmsmasters_option['amigos' . '_button_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_button_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_button_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_button_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_button_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_button_font_text_transform'] . ";
	}

	.cmsmasters_button,
	#fbuilder input[type=button] {
		letter-spacing: 1px;
	}

	.cmsmasters-form-builder .cmsmasters_button {
		line-height:" . ((int) $cmsmasters_option['amigos' . '_button_font_line_height'] + 13) . "px;
	}
	
	.cmsmasters_quotes_slider .cmsmasters_quote_subtitle,
	.cmsmasters_quotes_slider .cmsmasters_quote_site a {
		line-height:" . ((int) $cmsmasters_option['amigos' . '_button_font_line_height'] - 16) . "px;
	}

	.gform_wrapper .gform_footer input.button,
	.gform_wrapper .gform_footer input[type=submit] {
		font-size:" . $cmsmasters_option['amigos' . '_button_font_font_size'] . "px !important;
	}
	
	.cmsmasters_button.cmsmasters_but_icon_dark_bg,
	.cmsmasters_button.cmsmasters_but_icon_light_bg,
	.cmsmasters_button.cmsmasters_but_icon_divider,
	.cmsmasters_button.cmsmasters_but_icon_inverse {
		padding-left:" . ((int) $cmsmasters_option['amigos' . '_button_font_line_height'] + 20) . "px;
	}
	
	.cmsmasters_button.cmsmasters_but_icon_dark_bg:before,
	.cmsmasters_button.cmsmasters_but_icon_light_bg:before,
	.cmsmasters_button.cmsmasters_but_icon_divider:before,
	.cmsmasters_button.cmsmasters_but_icon_inverse:before,
	.cmsmasters_button.cmsmasters_but_icon_dark_bg:after,
	.cmsmasters_button.cmsmasters_but_icon_light_bg:after,
	.cmsmasters_button.cmsmasters_but_icon_divider:after,
	.cmsmasters_button.cmsmasters_but_icon_inverse:after {
		width:" . $cmsmasters_option['amigos' . '_button_font_line_height'] . "px;
	}
	/* Finish Button Font */


	/* Start Small Text Font */
	small,
	form .formError .formErrorContent,
	.cmsmasters_post_masonry .cmsmasters_post_date,
	.cmsmasters_single_slider .cmsmasters_single_slider_item_inner .cmsmasters_single_slider_item_date,
	.cmsmasters_post_masonry .cmsmasters_post_cont_info > span,
	.cmsmasters_post_masonry .cmsmasters_post_cont_info > span a {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_small_font_google_font']) . $cmsmasters_option['amigos' . '_small_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_small_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_small_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_small_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_small_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['amigos' . '_small_font_text_transform'] . ";
	}
	
	.cmsmasters_single_slider .cmsmasters_single_slider_item_inner .cmsmasters_single_slider_item_date {
		font-size:" . ((int) $cmsmasters_option['amigos' . '_small_font_font_size'] - 1) . "px;
	}
	
	.gform_wrapper .description,
	.gform_wrapper .gfield_description,
	.gform_wrapper .gsection_description,
	.gform_wrapper .instruction {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_small_font_google_font']) . $cmsmasters_option['amigos' . '_small_font_system_font'] . " !important;
		font-size:" . $cmsmasters_option['amigos' . '_small_font_font_size'] . "px !important;
		line-height:" . $cmsmasters_option['amigos' . '_small_font_line_height'] . "px !important;
	}
	/* Finish Small Text Font */


	/* Start Text Fields Font */
	input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	textarea,
	select,
	option {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_input_font_google_font']) . $cmsmasters_option['amigos' . '_input_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_input_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_input_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_input_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_input_font_font_style'] . ";
	}
	
	textarea,
	.cmsmasters-form-builder form textarea {
		background-size:100% " . $cmsmasters_option['amigos' . '_input_font_line_height'] . "px;
		min-height:" . $cmsmasters_option['amigos' . '_input_font_line_height'] . "px;
		height:" . $cmsmasters_option['amigos' . '_input_font_line_height'] . "px;
	}
	
	textarea:focus,
	textarea.area_opened,
	.cmsmasters-form-builder form textarea:focus,
	.cmsmasters-form-builder form textarea.area_opened {
		height:210px;
	}
	
	textarea:focus {
		min-height:" . ((int) $cmsmasters_option['amigos' . '_input_font_line_height'] * 3) . "px;
	}
	
	.gform_wrapper input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]),
	.gform_wrapper textarea,
	.gform_wrapper select {
		font-size:" . $cmsmasters_option['amigos' . '_input_font_font_size'] . "px !important;
	}
	/* Finish Text Fields Font */


	/* Start Blockquote Font */
	blockquote,
	.cmsmasters_quotes_slider .cmsmasters_quote_content {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_quote_font_google_font']) . $cmsmasters_option['amigos' . '_quote_font_system_font'] . ";
		font-size:" . $cmsmasters_option['amigos' . '_quote_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['amigos' . '_quote_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['amigos' . '_quote_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_quote_font_font_style'] . ";
	}

	@media only screen and (max-width: 600px) {
		.cmsmasters_quotes_slider .cmsmasters_quote_content {
			font-size:" . ((int) $cmsmasters_option['amigos' . '_quote_font_font_size'] - 7) . "px;
			line-height:" . ((int) $cmsmasters_option['amigos' . '_quote_font_line_height'] - 15) . "px;
		}
	}
	
	q {
		font-family:" . amigos_get_google_font($cmsmasters_option['amigos' . '_quote_font_google_font']) . $cmsmasters_option['amigos' . '_quote_font_system_font'] . ";
		font-weight:" . $cmsmasters_option['amigos' . '_quote_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['amigos' . '_quote_font_font_style'] . ";
	}
	/* Finish Blockquote Font */

/***************** Finish Theme Font Styles ******************/


";
	
	
	return apply_filters('amigos_theme_fonts_filter', $custom_css);
}

