<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version		1.0.0
 * 
 * Posts Slider Post Template
 * Created by CMSMasters
 * 
 */


$cmsmasters_metadata = explode(',', $cmsmasters_post_metadata);


$title = in_array('title', $cmsmasters_metadata) ? true : false;
$excerpt = (in_array('excerpt', $cmsmasters_metadata) && amigos_slider_post_check_exc_cont('post')) ? true : false;
$date = in_array('date', $cmsmasters_metadata) ? true : false;
$categories = (get_the_category() && (in_array('categories', $cmsmasters_metadata))) ? true : false;
$author = in_array('author', $cmsmasters_metadata) ? true : false;
$views = in_array('views', $cmsmasters_metadata) ? true : false;
$comments = (comments_open() && (in_array('comments', $cmsmasters_metadata))) ? true : false;
$likes = in_array('likes', $cmsmasters_metadata) ? true : false;
$more = in_array('more', $cmsmasters_metadata) ? true : false;


$cmsmasters_post_format = get_post_format();

?>
<!-- Start Posts Slider Post Article -->
<article id="post-<?php the_ID(); ?>" <?php post_class('cmsmasters_slider_post'); ?>>
	<div class="cmsmasters_slider_post_outer">
	<?php
		echo '<div class="cmsmasters_slider_post_img_wrap">';
		
			amigos_thumb_rollover(get_the_ID(), 'cmsmasters-square-thumb', false, false, false, false, false, false, false, false, true, false, false);
			
		
		echo '</div>';
		
		
		if ($date || $author || $title || $categories || $excerpt || $more || $views || $comments || $likes) {
			echo '<div class="cmsmasters_slider_post_inner">';

				if ($date || $author|| $categories) {
					echo '<div class="cmsmasters_slider_post_info">';
					
					$date ? amigos_get_slider_post_date('post') : '';
				
					$author ? amigos_get_slider_post_author('post') : '';

					$categories ? amigos_get_slider_post_category(get_the_ID(), 'category', 'post') : '';

					echo '</div>';
				}				
				
				
				$title ? amigos_slider_post_heading(get_the_ID(), 'post', 'h4') : '';			
				
				$excerpt ? amigos_slider_post_exc_cont('post') : '';
				
				
				if ($more || $views || $comments || $likes) {
					echo '<footer class="cmsmasters_slider_post_footer entry-meta">';
						
						$more ? amigos_slider_post_more(get_the_ID()) : '';
						
						
						if ($views || $comments || $likes) {
							echo '<div class="cmsmasters_slider_post_info entry-meta">';
								
								$views ? amigos_get_posts_slider_views() : '';
								
								$comments ? amigos_get_slider_post_comments('post') : '';
								
								$likes ? amigos_slider_post_like('post') : '';
								
							echo '</div>';
						}
						
					echo '</footer>';
				}
				
			echo '</div>';
		}
	?>
	</div>
</article>
<!-- Finish Posts Slider Post Article -->

