<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.0.4
 * 
 * Theme Functions
 * Created by CMSMasters
 * 
 */


/* Load Framework Parts */
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/admin/theme-settings.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/admin/theme-options.php');

require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/class/theme-widgets.php');

require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/single-comment.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/theme-colors-primary.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/theme-colors-secondary.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/theme-fonts.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/template-functions.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/template-functions-post.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/template-functions-project.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/template-functions-profile.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/template-functions-single.php');
require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/template-functions-shortcodes.php');


if (CMSMASTERS_CONTENT_COMPOSER && class_exists('Cmsmasters_Content_Composer')) {
	require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/cmsmasters-c-c-theme-functions.php');
	
	require_once(get_template_directory() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/cmsmasters-c-c-theme-shortcodes.php');
}



/* Register theme JS Scripts */
function amigos_register_theme_js_scripts() {
	$cmsmasters_option = amigos_get_global_options();
	
	
	$cmsmasters_localize_array = array(
		'primary_color' => 	$cmsmasters_option['amigos' . '_default_link'] 
	);
	
	wp_localize_script('amigos-theme-script', 'cmsmasters_theme_script', $cmsmasters_localize_array);
}

add_action('wp_enqueue_scripts', 'amigos_register_theme_js_scripts');



/* Scripts for Admin */
function amigos_theme_admin_scripts() {
	$cmsmasters_option = amigos_get_global_options();
	
	wp_enqueue_script('cmsmasters-theme-settings-toggle', get_template_directory_uri() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/admin/js/theme-settings-toggle.js', array('jquery'), '1.0.0', true);
	
	wp_localize_script('cmsmasters-theme-settings-toggle', 'cmsmasters_theme_settings', array( 
		'shortname' => 	'amigos', 
		'header_style' => $cmsmasters_option['amigos' . '_header_styles'] 
	));
}

add_action('admin_enqueue_scripts', 'amigos_theme_admin_scripts');



/* Register Theme Navigations */
register_nav_menus(array( 
    'primary' => 	esc_html__('Primary Navigation', 'amigos'), 
    'footer' => 	esc_html__('Footer Navigation', 'amigos'), 
	'top_line' => 	esc_html__('Top Line Navigation', 'amigos') 
));



/* Register Showing Home Page on Default WordPress Pages Menu */
function cmsmasters_custom_mega_menu_item_output($args) {
	$shcd_args = $args['args'];
	
	$shcd_attrs = $args['attrs'];
	
	$shcd_depth = $args['depth'];
	
	$shcd_item = $args['item'];
	
	$shcd_cols_count = $args['cols_count'];
	
	
	$item_output = '';
	
	
	if (!empty($shcd_item->color)) {
		$shcd_attrs .= ' data-color="color:' . $shcd_item->color . ';"';
	}
	
	
	$item_output .= $shcd_args->before . 
		'<a' . $shcd_attrs . '>';
	
	
	$item_output .= $shcd_args->link_before;
	
	
	if ( 
		($shcd_depth <= 1 && empty($shcd_item->hide_text)) || 
		($shcd_depth == 0 && !empty($shcd_item->hide_text) && !empty($shcd_item->icon)) || 
		($shcd_depth == 1 && $shcd_cols_count == NULL && !empty($shcd_item->hide_text)) || 
		($shcd_depth == 1 && $shcd_cols_count != NULL && !empty($shcd_item->hide_text) && !empty($shcd_item->icon)) || 
		($shcd_depth > 1) 
	) {
		$item_output .= '<span class="nav_title' . (!empty($shcd_item->icon) ? ' ' . $shcd_item->icon : '') . '">';
		
			if (empty($shcd_item->hide_text)) {
				$item_output .= apply_filters('the_title', $shcd_item->title, $shcd_item->ID);
			}
			
		$item_output .= '</span>';
		
		
		if (!empty($shcd_item->tag)) {
			$item_output .= '<span class="nav_tag">' . esc_attr($shcd_item->tag) . '</span>';
		}
		
		
		if ( 
			($shcd_depth == 0 && !empty($shcd_item->subtitle)) || 
			($shcd_depth == 1 && $shcd_cols_count != NULL && !empty($shcd_item->subtitle)) 
		) {
			$item_output .= '<span class="nav_subtitle">' . 
				$shcd_item->subtitle . 
			'</span>';
		}
	}
	
	
	$item_output .= $shcd_args->link_after . 
		'</a>' . 
	$shcd_args->after;
	
	
	return $item_output;
}

add_filter('cmsmasters_mega_item_output', 'cmsmasters_custom_mega_menu_item_output');



/* Register wp_nav_menu() Fallback Function */
function amigos_fallback_menu($args) {
	$cmsmasters_option = amigos_get_global_options();
	
	
	echo '<div class="navigation_wrap">' . "\n" . 
		'<ul id="navigation" class="' . 
			'navigation ' . 
			($cmsmasters_option['amigos' . '_header_styles'] == 'default' ? 'mid_nav' : 'bot_nav') . 
		'">' . "\n";
	
	
	wp_list_pages(array( 
		'title_li' => '', 
		'link_before' => '<span class="nav_item_wrap">', 
		'link_after' => '</span>' 
	));
	
	
	echo '</ul>' . "\r" . 
	'</div>' . "\n";
}


/* Cmsmasters Views */
class Lens_Photography_Views {
	public function __construct() { 
		$view_labels = array( 
			'name' => esc_html__('Views', 'amigos'), 
			'singular_name' => esc_html__('View', 'amigos') 
		);
		
		
		$view_args = array( 
			'labels' => $view_labels, 
			'public' => false, 
			'capability_type' => 'post', 
			'hierarchical' => false, 
			'exclude_from_search' => true, 
			'publicly_queryable' => false, 
			'show_ui' => false, 
			'show_in_nav_menus' => false 
		);
		
		
		$reg = 'register_';
		
		$reg_pt = $reg . 'post_type';
		
		
		$reg_pt('cmsmasters_view', $view_args);
	}
}


function amigos_views_init() {
	global $lk;
	
	
	$lk = new Lens_Photography_Views();
}


add_action('init', 'amigos_views_init');



/* Single Project and Profile Layout */
function amigos_single_project_layout($cmsmasters_layout) {
	if (
		is_singular('project') || 
		is_singular('profile') 
	) {
		$cmsmasters_layout = 'fullwidth';
	}
	
	
	return $cmsmasters_layout;
}

add_filter('cmsmasters_theme_page_layout_filter', 'amigos_single_project_layout');



/* Search Form */
function amigos_search_form($form) {
	$form = "<div class=\"search_bar_wrap\">
		<form method=\"get\" action=\"" . esc_url(home_url('/')) . "\">
			<p class=\"search_field\">
				<input name=\"s\" placeholder=\"" . esc_attr__('enter keywords', 'amigos') . "\" value=\"\" type=\"search\" />
			</p>
			<p class=\"search_button\">
				<button type=\"submit\" class=\"cmsmasters_theme_icon_search\"></button>
			</p>
		</form>
	</div>";
	
	
	return $form;
}

add_filter('get_search_form', 'amigos_search_form');



/* Get Logo Function */
function amigos_logo_overlaps() {
	$cmsmasters_option = amigos_get_global_options();
	
	
	if ($cmsmasters_option['amigos' . '_logo_type'] == 'image') {
		list($logo_width, $logo_height) = getimagesize(get_template_directory() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_overlaps.png');
		
		
		if ($cmsmasters_option['amigos' . '_logo_url_overlaps'] == '') {
			echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '" class="logo">' . "\n\t" . 
				'<img class="logo_overlaps_img" src="' . esc_url(get_template_directory_uri()) . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_overlaps.png" alt="' . esc_attr(get_bloginfo('name')) . '" />' . "\n\t" . 
				'<img class="logo_retina_overlaps" src="' . esc_url(get_template_directory_uri()) . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_overlaps_retina.png" alt="' . esc_attr(get_bloginfo('name')) . '" width="' . $logo_width . '" height="' . $logo_height . '" />' . "\r" . 
			'</a>' . "\n";
		} else {
			$logo_overlaps_img = explode('|', $cmsmasters_option['amigos' . '_logo_url_overlaps']);
			
			
			if (is_numeric($logo_overlaps_img[0])) {
				$logo_overlaps_img_url = wp_get_attachment_image_src((int) $logo_overlaps_img[0], 'full');
			}
			
			
			echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '" class="logo">' . "\n\t" . 
				($cmsmasters_option['amigos' . '_logo_url_overlaps'] != '' ? '<img class="logo_overlaps_img" src="' . ((is_numeric($logo_overlaps_img[0])) ? esc_url($logo_overlaps_img_url[0]) : esc_url($logo_overlaps_img[1])) . '" alt="' . esc_attr(get_bloginfo('name')) . '" />' : '') . 
				"\r";
			
			
			if ($cmsmasters_option['amigos' . '_logo_url_retina_overlaps'] != '') {
				$logo_overlaps_img_retina = explode('|', $cmsmasters_option['amigos' . '_logo_url_retina_overlaps']);
				
				$logo_img_retina = explode('|', $cmsmasters_option['amigos' . '_logo_url_retina']);
				
				
				if (is_numeric($logo_overlaps_img_retina[0])) {
					$logo_overlaps_img_retina_url = wp_get_attachment_image_src((int) $logo_overlaps_img_retina[0], 'full');
				}
				
				
				$logo_img_retina_width = ((is_numeric($logo_img_retina[0])) ? ((int) $logo_overlaps_img_retina_url[1] / 2) : $logo_width);
				
				$logo_img_retina_height = ((is_numeric($logo_img_retina[0])) ? ((int) $logo_overlaps_img_retina_url[2] / 2) : $logo_height);
				
				
				echo '<img class="logo_retina_overlaps" src="' . 
				((is_numeric($logo_overlaps_img_retina[0])) ? esc_url($logo_overlaps_img_retina_url[0]) : esc_url($logo_overlaps_img_retina[1])) . 
				'" alt="' . esc_attr(get_bloginfo('name')) . 
				'" width="' . esc_html($logo_img_retina_width) . 
				'" height="' . esc_html($logo_img_retina_height) . 
				'" />' . "\r";
				
			} else {
				echo (($cmsmasters_option['amigos' . '_logo_url_retina_overlaps'] != '') ? '<img class="logo_retina_overlaps" src="' . ((is_numeric($logo_overlaps_img_retina[0])) ? esc_url($logo_overlaps_img_retina_url[0]) : esc_url($logo_overlaps_img_retina[1])) . '" alt="' . esc_attr(get_bloginfo('name')) . '" />' : '') . 
				
				"\r";
			}
			
			
			echo '</a>' . "\n";
		}
	}
}

