<?php
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version 	1.1.0
 * 
 * TGM-Plugin-Activation 2.6.1
 * Created by CMSMasters
 * 
 */


require_once(get_template_directory() . '/framework/class/class-tgm-plugin-activation.php');


if (!function_exists('amigos_register_theme_plugins')) {

function amigos_register_theme_plugins() { 
	$plugins = array( 
		array( 
			'name'					=> esc_html__('CMSMasters Content Composer', 'amigos'), 
			'slug'					=> 'cmsmasters-content-composer', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-content-composer.zip', 
			'required'				=> true, 
			'version'				=> '2.5.3',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		),
		array(
			'name'					=> esc_html__('CMSMasters Custom Fonts', 'amigos'),
			'slug'					=> 'cmsmasters-custom-fonts',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-custom-fonts.zip',
			'required'				=> true,
			'version'				=> '1.0.1',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array(
			'name'					=> esc_html__('CMSMasters Importer', 'amigos'),
			'slug'					=> 'cmsmasters-importer',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-importer.zip',
			'required'				=> true,
			'version'				=> '1.0.7',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array( 
			'name' 					=> esc_html__('LayerSlider WP', 'amigos'), 
			'slug' 					=> 'LayerSlider', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/LayerSlider.zip', 
			'required'				=> false, 
			'version'				=> '7.7.1', 
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		), 
		array( 
			'name' 					=> esc_html__('Revolution Slider', 'amigos'), 
			'slug' 					=> 'revslider', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/revslider.zip', 
			'required'				=> false, 
			'version'				=> '6.6.12',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		), 
		array( 
			'name'					=> esc_html__('Envato Market', 'amigos'), 
			'slug'					=> 'envato-market', 
			'source'				=> 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
			'required'				=> false,
		), 
		array( 
			'name'					=> esc_html__('GDPR Cookie Consent', 'amigos'),
			'slug'					=> 'cookie-law-info',
			'required'				=> false 
		), 
		array( 
			'name' 					=> esc_html__('The Events Calendar', 'amigos'), 
			'slug' 					=> 'the-events-calendar', 
			'required'				=> false 
		), 
		array( 
			'name' 					=> esc_html__('Calculated Fields Form', 'amigos'), 
			'slug' 					=> 'calculated-fields-form', 
			'required'				=> false 
		), 
		array( 
			'name' 					=> esc_html__('Contact Form 7', 'amigos'), 
			'slug' 					=> 'contact-form-7', 
			'required' 				=> false 
		)
	);
	
	
	$config = array( 
		'id' => 			'amigos', 
		'menu' => 			'theme-required-plugins', 
		'strings' => array( 
			'page_title' => 	esc_html__('Theme Required & Recommended Plugins', 'amigos'), 
			'menu_title' => 	esc_html__('Theme Plugins', 'amigos'), 
			'return' => 		esc_html__('Return to Theme Required & Recommended Plugins', 'amigos') 
		) 
	);
	
	
	tgmpa($plugins, $config);
}

}

add_action('tgmpa_register', 'amigos_register_theme_plugins');

