<?php 
/**
 * @package 	WordPress
 * @subpackage 	Amigos
 * @version		1.0.8
 * 
 * Theme Settings Defaults
 * Created by CMSMasters
 * 
 */


/* Theme Settings General Default Values */
if (!function_exists('amigos_settings_general_defaults')) {

function amigos_settings_general_defaults($id = false) {
	$settings = array( 
		'general' => array( 
			'amigos' . '_theme_layout' => 		'liquid', 
			'amigos' . '_logo_type' => 			'image', 
			'amigos' . '_logo_url' => 			'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo.png', 
			'amigos' . '_logo_url_retina' => 	'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_retina.png',
			'amigos' . '_logo_title' => 		get_bloginfo('name') ? get_bloginfo('name') : 'Amigos',
			'amigos' . '_logo_subtitle' => 		'', 
			'amigos' . '_logo_custom_color' => 	0, 
			'amigos' . '_logo_title_color' => 	'', 
			'amigos' . '_logo_subtitle_color' => ''
		), 
		'bg' => array( 
			'amigos' . '_bg_col' => 			'#ffffff', 
			'amigos' . '_bg_img_enable' => 	    0,
			'amigos' . '_bg_img' => 			'', 
			'amigos' . '_bg_rep' => 			'no-repeat', 
			'amigos' . '_bg_pos' => 			'top center', 
			'amigos' . '_bg_att' => 			'scroll', 
			'amigos' . '_bg_size' => 			'cover' 
		), 
		'header' => array( 
			'amigos' . '_fixed_header' => 				1, 
			'amigos' . '_header_overlaps' => 			1,
			'amigos' . '_header_top_line' => 			0,
			'amigos' . '_header_top_height' => 			'35', 
			'amigos' . '_header_top_line_short_info' => '',
			'amigos' . '_header_top_line_add_cont' => 	'social', 
			'amigos' . '_header_styles' => 				'default', 
			'amigos' . '_header_mid_height' => 			'76', 
			'amigos' . '_header_bot_height' => 			'50', 
			'amigos' . '_header_search' => 				0, 
			'amigos' . '_header_add_cont' => 			'social',
			'amigos' . '_header_add_cont_cust_html' => 	'' 
		), 
		'content' => array( 
			'amigos' . '_layout' => 				'r_sidebar',
			'amigos' . '_archives_layout' => 		'r_sidebar',
			'amigos' . '_search_layout' => 			'r_sidebar',
			'amigos' . '_other_layout' => 			'r_sidebar',
			'amigos' . '_heading_alignment' => 		'center', 
			'amigos' . '_heading_scheme' => 		'default',
			'amigos' . '_heading_bg_image_enable' => 1,
			'amigos' . '_heading_bg_image' => 		'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/headline.jpg', 
			'amigos' . '_heading_bg_repeat' => 		'no-repeat', 
			'amigos' . '_heading_bg_attachment' => 	'scroll', 
			'amigos' . '_heading_bg_size' => 		'cover',
			'amigos' . '_heading_bg_color' => 		'', 
			'amigos' . '_heading_height' => 		'440',
			'amigos' . '_breadcrumbs' => 			1,
			'amigos' . '_bottom_scheme' => 			'default', 
			'amigos' . '_bottom_sidebar' => 		0,
			'amigos' . '_bottom_sidebar_layout' => 	'14141414' 
		), 
		'footer' => array( 
			'amigos' . '_footer_scheme' => 				'footer', 
			'amigos' . '_footer_type' => 				'default',
			'amigos' . '_footer_additional_content' => 	'nav', 
			'amigos' . '_footer_logo' => 				0,
			'amigos' . '_footer_logo_url' => 			'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_footer.png',
			'amigos' . '_footer_logo_url_retina' => 	'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_footer_retina.png',
			'amigos' . '_footer_nav' => 				1,
			'amigos' . '_footer_social' => 				1, 
			'amigos' . '_footer_html' => 				'',
			'amigos' . '_footer_copyright' => 			'Amigos' . ' &copy; ' . date('Y') . ' / ' . esc_html__('All Rights Reserved', 'amigos') 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



/* Theme Settings Fonts Default Values */
if (!function_exists('amigos_settings_font_defaults')) {

function amigos_settings_font_defaults($id = false) {
	$settings = array( 
		'content' => array( 
			'amigos' . '_content_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'15', 
				'line_height' => 		'24', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal' 
			) 
		), 
		'link' => array( 
			'amigos' . '_link_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'15', 
				'line_height' => 		'24', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'amigos' . '_link_hover_decoration' => 	'none' 
		), 
		'nav' => array( 
			'amigos' . '_nav_title_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'15', 
				'line_height' => 		'20', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			), 
			'amigos' . '_nav_dropdown_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'14', 
				'line_height' => 		'20', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			) 
		), 
		'heading' => array( 
			'amigos' . '_h1_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Antic+Didone', 
				'font_size' => 			'56', 
				'line_height' => 		'68', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'amigos' . '_h2_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Antic+Didone', 
				'font_size' => 			'42', 
				'line_height' => 		'52', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'amigos' . '_h3_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Antic+Didone', 
				'font_size' => 			'30', 
				'line_height' => 		'32', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'amigos' . '_h4_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'18', 
				'line_height' => 		'26', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'uppercase', 
				'text_decoration' => 	'none' 
			), 
			'amigos' . '_h5_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'16', 
				'line_height' => 		'22', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'uppercase', 
				'text_decoration' => 	'none' 
			), 
			'amigos' . '_h6_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'12', 
				'line_height' => 		'22', 
				'font_weight' => 		'bold', 
				'font_style' => 		'normal', 
				'text_transform' => 	'uppercase', 
				'text_decoration' => 	'none' 
			) 
		), 
		'other' => array( 
			'amigos' . '_button_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'12', 
				'line_height' => 		'40', 
				'font_weight' => 		'bold', 
				'font_style' => 		'normal', 
				'text_transform' => 	'uppercase' 
			), 
			'amigos' . '_small_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'13', 
				'line_height' => 		'24', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			), 
			'amigos' . '_input_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Karla:400,400italic,700,700italic',
				'font_size' => 			'15', 
				'line_height' => 		'42', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal' 
			), 
			'amigos' . '_quote_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Antic+Didone', 
				'font_size' => 			'32', 
				'line_height' => 		'48', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal' 
			) 
		),
		'google' => array(
			'amigos' . '_google_web_fonts' => array(
				'Karla:400,400italic,700,700italic|Karla',
				'Titillium+Web:300,300italic,400,400italic,600,600italic,700,700italic|Titillium Web',
				'Roboto:300,300italic,400,400italic,500,500italic,700,700italic|Roboto',
				'Roboto+Condensed:400,400italic,700,700italic|Roboto Condensed',
				'Open+Sans:300,300italic,400,400italic,700,700italic|Open Sans',
				'Open+Sans+Condensed:300,300italic,700|Open Sans Condensed',
				'Droid+Sans:400,700|Droid Sans',
				'Droid+Serif:400,400italic,700,700italic|Droid Serif',
				'PT+Sans:400,400italic,700,700italic|PT Sans',
				'PT+Sans+Caption:400,700|PT Sans Caption',
				'PT+Sans+Narrow:400,700|PT Sans Narrow',
				'PT+Serif:400,400italic,700,700italic|PT Serif',
				'Ubuntu:400,400italic,700,700italic|Ubuntu',
				'Ubuntu+Condensed|Ubuntu Condensed',
				'Headland+One|Headland One',
				'Source+Sans+Pro:300,300italic,400,400italic,700,700italic|Source Sans Pro',
				'Lato:400,400italic,700,700italic|Lato',
				'Cuprum:400,400italic,700,700italic|Cuprum',
				'Oswald:300,400,700|Oswald',
				'Yanone+Kaffeesatz:300,400,700|Yanone Kaffeesatz',
				'Lobster|Lobster',
				'Lobster+Two:400,400italic,700,700italic|Lobster Two',
				'Questrial|Questrial',
				'Raleway:300,400,500,600,700|Raleway',
				'Dosis:300,400,500,700|Dosis',
				'Cutive+Mono|Cutive Mono',
				'Quicksand:300,400,700|Quicksand',
				'Montserrat:400,700|Montserrat',
				'Cookie|Cookie',
				'Antic+Didone|Antic+Didone'
			)
		)
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



// WP Color Picker Palettes
if (!function_exists('cmsmasters_color_picker_palettes')) {

function cmsmasters_color_picker_palettes() {
	$palettes = array( 
		'#575757',
		'#7e505f', 
		'#b6b6b6', 
		'#141414', 
		'#fefdfd', 
		'#ffffff', 
		'#e6e6e6' 
	);
	
	
	return $palettes;
}

}



// Theme Settings Color Schemes Default Colors
if (!function_exists('amigos_color_schemes_defaults')) {

function amigos_color_schemes_defaults($id = false) {
	$settings = array( 
		'default' => array( // content default color scheme
			'color' => 		'#575757', 
			'link' => 		'#7e505f', 
			'hover' => 		'#9c9c9c', 
			'heading' => 	'#141414', 
			'bg' => 		'#fefdfd', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#e6e6e6' 
		), 
		'header' => array( // Header color scheme
			'mid_color' => 		'#ffffff', 
			'mid_link' => 		'#ffffff', 
			'mid_hover' => 		'#ffffff', 
			'mid_bg' => 		'rgba(255,255,255,0)', 
			'mid_bg_scroll' => 	'#ffffff', 
			'mid_border' => 	'#rgba(255,255,255,0)', 
			'bot_color' => 		'#ffffff', 
			'bot_link' => 		'#ffffff', 
			'bot_hover' => 		'#ffffff', 
			'bot_bg' => 		'rgba(255,255,255,0)', 
			'bot_bg_scroll' => 	'#ffffff', 
			'bot_border' => 	'rgba(255,255,255,0)' 
		), 
		'navigation' => array( // Navigation color scheme
			'title_link' => 			'#ffffff', 
			'title_link_hover' => 		'#ffffff', 
			'title_link_current' => 	'#ffffff', 
			'title_link_subtitle' => 	'rgba(255,255,255,0.6)', 
			'title_link_bg' => 			'rgba(255,255,255,0)', 
			'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
			'title_link_bg_current' => 	'rgba(255,255,255,0)', 
			'title_link_border' => 		'rgba(255,255,255,0)', 
			'dropdown_text' => 			'#272727', 
			'dropdown_bg' => 			'#ffffff', 
			'dropdown_border' => 		'#e1e1e1', 
			'dropdown_link' => 			'#272727', 
			'dropdown_link_hover' => 	'#b6b6b6', 
			'dropdown_link_subtitle' => 'rgba(39,39,39,0.5)', 
			'dropdown_link_highlight' => 'rgba(255,255,255,0)', 
			'dropdown_link_border' => 	'rgba(255,255,255,0)' 
		), 
		'header_top' => array( // Header Top color scheme
			'color' => 					'#ffffff', 
			'link' => 					'#ffffff', 
			'hover' => 					'#ffffff', 
			'bg' => 					'rgba(255,255,255,0)', 
			'border' => 				'rgba(255,255,255,0.1)', 
			'title_link' => 			'#ffffff', 
			'title_link_hover' => 		'#ffffff', 
			'title_link_bg' => 			'rgba(255,255,255,0)', 
			'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
			'title_link_border' => 		'rgba(255,255,255,0)', 
			'dropdown_bg' => 			'#ffffff', 
			'dropdown_border' => 		'rgba(255,255,255,0)', 
			'dropdown_link' => 			'#272727', 
			'dropdown_link_hover' => 	'#b6b6b6', 
			'dropdown_link_highlight' => 'rgba(255,255,255,0)', 
			'dropdown_link_border' => 	'rgba(255,255,255,0)' 
		), 
		'footer' => array( // Footer color scheme
			'color' => 		'#6d6d6d', 
			'link' => 		'#6d6d6d', 
			'hover' => 		'#b6b6b6', 
			'heading' => 	'#272727', 
			'bg' => 		'#ffffff', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#e6e6e6' 
		), 
		'first' => array( // custom color scheme 1
			'color' => 		'#595959', 
			'link' => 		'#ff6c2f', 
			'hover' => 		'#3b3b3b', 
			'heading' => 	'#292929', 
			'bg' => 		'#ffffff', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#e4e4e4' 
		), 
		'second' => array( // custom color scheme 2
			'color' => 		'#878787', 
			'link' => 		'#ff6c2f', 
			'hover' => 		'#3b3b3b', 
			'heading' => 	'#292929', 
			'bg' => 		'#fbfbfb', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#e4e4e4' 
		), 
		'third' => array( // custom color scheme 3
			'color' => 		'#878787', 
			'link' => 		'#ff6c2f', 
			'hover' => 		'#3b3b3b', 
			'heading' => 	'#292929', 
			'bg' => 		'#fbfbfb', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#e4e4e4' 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



// Theme Settings Elements Default Values
if (!function_exists('amigos_settings_element_defaults')) {

function amigos_settings_element_defaults($id = false) {
	$settings = array( 
		'sidebar' => array( 
			'amigos' . '_sidebar' => 	'' 
		), 
		'icon' => array( 
			'amigos' . '_social_icons' => array( 
				'cmsmasters-icon-facebook-1|#|' . esc_html__('Facebook', 'amigos') . '|true|#d7d7d7|#b6b6b6', 
				'cmsmasters-icon-gplus-1|#|' . esc_html__('Google+', 'amigos') . '|true|#d7d7d7|#b6b6b6', 
				'cmsmasters-icon-instagram|#|' . esc_html__('Instagram', 'amigos') . '|true|#d7d7d7|#b6b6b6', 
				'cmsmasters-icon-twitter|#|' . esc_html__('Twitter', 'amigos') . '|true|#d7d7d7|#b6b6b6', 
				'cmsmasters-icon-youtube-play|#|' . esc_html__('YouTube', 'amigos') . '|true|#d7d7d7|#b6b6b6' 
			) 
		), 
		'lightbox' => array( 
			'amigos' . '_ilightbox_skin' => 					'dark', 
			'amigos' . '_ilightbox_path' => 					'vertical', 
			'amigos' . '_ilightbox_infinite' => 				0, 
			'amigos' . '_ilightbox_aspect_ratio' => 			1, 
			'amigos' . '_ilightbox_mobile_optimizer' => 		1, 
			'amigos' . '_ilightbox_max_scale' => 				1, 
			'amigos' . '_ilightbox_min_scale' => 				0.2, 
			'amigos' . '_ilightbox_inner_toolbar' => 			0, 
			'amigos' . '_ilightbox_smart_recognition' => 		0, 
			'amigos' . '_ilightbox_fullscreen_one_slide' => 	0, 
			'amigos' . '_ilightbox_fullscreen_viewport' => 	'center', 
			'amigos' . '_ilightbox_controls_toolbar' => 		1, 
			'amigos' . '_ilightbox_controls_arrows' => 		0, 
			'amigos' . '_ilightbox_controls_fullscreen' => 	1, 
			'amigos' . '_ilightbox_controls_thumbnail' => 	1, 
			'amigos' . '_ilightbox_controls_keyboard' => 		1, 
			'amigos' . '_ilightbox_controls_mousewheel' => 	1, 
			'amigos' . '_ilightbox_controls_swipe' => 		1, 
			'amigos' . '_ilightbox_controls_slideshow' => 	0 
		), 
		'sitemap' => array( 
			'amigos' . '_sitemap_nav' => 			1, 
			'amigos' . '_sitemap_categs' => 		1, 
			'amigos' . '_sitemap_tags' => 		1, 
			'amigos' . '_sitemap_month' => 		1, 
			'amigos' . '_sitemap_pj_categs' => 	1, 
			'amigos' . '_sitemap_pj_tags' => 		1 
		), 
		'error' => array( 
			'amigos' . '_error_color' => 				'#ffffff', 
			'amigos' . '_error_bg_color' => 			'rgba(255,255,255,0)', 
			'amigos' . '_error_bg_img_enable' => 		1, 
			'amigos' . '_error_bg_image' => 			'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/error_bg.jpg', 
			'amigos' . '_error_bg_rep' => 			'no-repeat', 
			'amigos' . '_error_bg_pos' => 			'top center', 
			'amigos' . '_error_bg_att' => 			'scroll', 
			'amigos' . '_error_bg_size' => 			'cover', 
			'amigos' . '_error_search' => 			1, 
			'amigos' . '_error_sitemap_button' => 	1, 
			'amigos' . '_error_sitemap_link' => 		'' 
		), 
		'code' => array( 
			'amigos' . '_custom_css' => 			'', 
			'amigos' . '_custom_js' => 			'', 
			'amigos' . '_gmap_api_key' => 		'', 
			'amigos' . '_twitter_access_token' => 	'' 
		), 
		'recaptcha' => array( 
			'amigos' . '_recaptcha_public_key' => 	'', 
			'amigos' . '_recaptcha_private_key' => 	'' 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



// Theme Settings Single Posts Default Values
if (!function_exists('amigos_settings_single_defaults')) {

function amigos_settings_single_defaults($id = false) {
	$settings = array( 
		'post' => array( 
			'amigos' . '_blog_post_layout' => 		'fullwidth', 
			'amigos' . '_blog_post_title' => 			1, 
			'amigos' . '_blog_post_date' => 			1, 
			'amigos' . '_blog_post_cat' => 			1, 
			'amigos' . '_blog_post_author' => 		1, 
			'amigos' . '_blog_post_comment' => 		1, 
			'amigos' . '_blog_post_tag' => 			1, 
			'amigos' . '_blog_post_like' => 			1, 
			'amigos' . '_blog_post_nav_box' => 		1, 
			'amigos' . '_blog_post_nav_order_cat' => 	0, 
			'amigos' . '_blog_post_share_box' => 		1, 
			'amigos' . '_blog_post_author_box' => 	1, 
			'amigos' . '_blog_more_posts_box' => 		'popular', 
			'amigos' . '_blog_more_posts_count' => 	'3', 
			'amigos' . '_blog_more_posts_pause' => 	'5' 
		), 
		'project' => array( 
			'amigos' . '_portfolio_project_title' => 			1, 
			'amigos' . '_portfolio_project_details_title' => 	esc_html__('Service details', 'amigos'), 
			'amigos' . '_portfolio_project_date' => 			1, 
			'amigos' . '_portfolio_project_cat' => 			1, 
			'amigos' . '_portfolio_project_author' => 		1, 
			'amigos' . '_portfolio_project_comment' => 		0, 
			'amigos' . '_portfolio_project_tag' => 			0, 
			'amigos' . '_portfolio_project_like' => 			1, 
			'amigos' . '_portfolio_project_link' => 			0, 
			'amigos' . '_portfolio_project_share_box' => 		1, 
			'amigos' . '_portfolio_project_nav_box' => 		1, 
			'amigos' . '_portfolio_project_nav_order_cat' => 	0, 
			'amigos' . '_portfolio_project_author_box' => 	1, 
			'amigos' . '_portfolio_more_projects_box' => 		'popular', 
			'amigos' . '_portfolio_more_projects_count' => 	'4', 
			'amigos' . '_portfolio_more_projects_pause' => 	'5', 
			'amigos' . '_portfolio_project_slug' => 			'service', 
			'amigos' . '_portfolio_pj_categs_slug' => 		'pj-categs', 
			'amigos' . '_portfolio_pj_tags_slug' => 			'pj-tags' 
		), 
		'profile' => array( 
			'amigos' . '_profile_post_title' => 			1, 
			'amigos' . '_profile_post_details_title' => 	esc_html__('Profile details', 'amigos'), 
			'amigos' . '_profile_post_cat' => 			1, 
			'amigos' . '_profile_post_comment' => 		1, 
			'amigos' . '_profile_post_like' => 			1, 
			'amigos' . '_profile_post_nav_box' => 		1, 
			'amigos' . '_profile_post_nav_order_cat' => 	0, 
			'amigos' . '_profile_post_share_box' => 		1, 
			'amigos' . '_profile_post_slug' => 			'profile', 
			'amigos' . '_profile_pl_categs_slug' => 		'pl-categs' 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



/* Project Puzzle Proportion */
if (!function_exists('amigos_project_puzzle_proportion')) {

function amigos_project_puzzle_proportion() {
	return 0.7414;
}

}



/* Project Puzzle Proportion */
if (!function_exists('amigos_project_puzzle_large_gar_parameters')) {

function amigos_project_puzzle_large_gar_parameters() {
	$parameter = array ( 
		'container_width' 		=> 1160, 
		'bottomStaticPadding' 	=> 2 
	);
	
	
	return $parameter;
}

}



/* Theme Image Thumbnails Size */
if (!function_exists('amigos_get_image_thumbnail_list')) {

function amigos_get_image_thumbnail_list() {
	$list = array( 
		'cmsmasters-small-thumb' => array( 
			'width' => 		80, 
			'height' => 	80, 
			'crop' => 		true 
		), 
		'cmsmasters-square-thumb' => array( 
			'width' => 		300, 
			'height' => 	300, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Square', 'amigos') 
		), 
		'cmsmasters-blog-masonry-thumb' => array( 
			'width' => 		580, 
			'height' => 	420, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Masonry Blog', 'amigos') 
		), 
		'cmsmasters-project-thumb' => array( 
			'width' => 		580, 
			'height' => 	430, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Service', 'amigos') 
		), 
		'cmsmasters-project-masonry-thumb' => array( 
			'width' => 		580, 
			'height' => 	9999, 
			'title' => 		esc_attr__('Masonry Service', 'amigos') 
		), 
		'post-thumbnail' => array( 
			'width' => 		860, 
			'height' => 	500, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Featured', 'amigos') 
		), 
		'cmsmasters-masonry-thumb' => array( 
			'width' => 		860, 
			'height' => 	9999, 
			'title' => 		esc_attr__('Masonry', 'amigos') 
		), 
		'cmsmasters-full-thumb' => array( 
			'width' => 		1160, 
			'height' => 	600, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Full', 'amigos') 
		), 
		'cmsmasters-project-full-thumb' => array( 
			'width' => 		1160, 
			'height' => 	600, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Service Full', 'amigos') 
		), 
		'cmsmasters-full-masonry-thumb' => array( 
			'width' => 		1160, 
			'height' => 	9999, 
			'title' => 		esc_attr__('Masonry Full', 'amigos') 
		) 
	);
	
	
	return $list;
}

}



/* Project Post Type Registration Rename */
if (!function_exists('amigos_project_labels')) {

function amigos_project_labels() {
	return array( 
		'name' => 					esc_html__('Services', 'amigos'), 
		'singular_name' => 			esc_html__('Service', 'amigos'), 
		'menu_name' => 				esc_html__('Services', 'amigos'), 
		'all_items' => 				esc_html__('All Services', 'amigos'), 
		'add_new' => 				esc_html__('Add New', 'amigos'), 
		'add_new_item' => 			esc_html__('Add New Service', 'amigos'), 
		'edit_item' => 				esc_html__('Edit Service', 'amigos'), 
		'new_item' => 				esc_html__('New Service', 'amigos'), 
		'view_item' => 				esc_html__('View Service', 'amigos'), 
		'search_items' => 			esc_html__('Search services', 'amigos'), 
		'not_found' => 				esc_html__('No services found', 'amigos'), 
		'not_found_in_trash' => 	esc_html__('No services found in Trash', 'amigos') 
	);
}

}

add_filter('cmsmasters_project_labels_filter', 'amigos_project_labels');


if (!function_exists('amigos_pj_categs_labels')) {

function amigos_pj_categs_labels() {
	return array( 
		'name' => 					esc_html__('Service Categories', 'amigos'), 
		'singular_name' => 			esc_html__('Service Category', 'amigos') 
	);
}

}

add_filter('cmsmasters_pj_categs_labels_filter', 'amigos_pj_categs_labels');


if (!function_exists('amigos_pj_tags_labels')) {

function amigos_pj_tags_labels() {
	return array( 
		'name' => 					esc_html__('Service Tags', 'amigos'), 
		'singular_name' => 			esc_html__('Service Tag', 'amigos') 
	);
}

}

add_filter('cmsmasters_pj_tags_labels_filter', 'amigos_pj_tags_labels');



/* Profile Post Type Registration Rename */
if (!function_exists('amigos_profile_labels')) {

function amigos_profile_labels() {
	return array( 
		'name' => 					esc_html__('Profiles', 'amigos'), 
		'singular_name' => 			esc_html__('Profiles', 'amigos'), 
		'menu_name' => 				esc_html__('Profiles', 'amigos'), 
		'all_items' => 				esc_html__('All Profiles', 'amigos'), 
		'add_new' => 				esc_html__('Add New', 'amigos'), 
		'add_new_item' => 			esc_html__('Add New Profile', 'amigos'), 
		'edit_item' => 				esc_html__('Edit Profile', 'amigos'), 
		'new_item' => 				esc_html__('New Profile', 'amigos'), 
		'view_item' => 				esc_html__('View Profile', 'amigos'), 
		'search_items' => 			esc_html__('Search Profiles', 'amigos'), 
		'not_found' => 				esc_html__('No Profiles found', 'amigos'), 
		'not_found_in_trash' => 	esc_html__('No Profiles found in Trash', 'amigos') 
	);
}

}

// add_filter('cmsmasters_profile_labels_filter', 'amigos_profile_labels');


if (!function_exists('amigos_pl_categs_labels')) {

function amigos_pl_categs_labels() {
	return array( 
		'name' => 					esc_html__('Profile Categories', 'amigos'), 
		'singular_name' => 			esc_html__('Profile Category', 'amigos') 
	);
}

}

// add_filter('cmsmasters_pl_categs_labels_filter', 'amigos_pl_categs_labels');

